package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  StringType,
  UsernameType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class AdminConfirmSignUpRequest(
    userPoolId: UserPoolIdType,
    username: UsernameType,
    clientMetadata: Optional[Map[StringType, StringType]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminConfirmSignUpRequest = {
    import AdminConfirmSignUpRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminConfirmSignUpRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .username(UsernameType.unwrap(username): java.lang.String)
      .optionallyWith(
        clientMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.clientMetadata)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminConfirmSignUpRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminConfirmSignUpRequest
      .wrap(buildAwsValue())
}
object AdminConfirmSignUpRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminConfirmSignUpRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminConfirmSignUpRequest =
      zio.aws.cognitoidentityprovider.model.AdminConfirmSignUpRequest(
        userPoolId,
        username,
        clientMetadata.map(value => value)
      )
    def userPoolId: UserPoolIdType
    def username: UsernameType
    def clientMetadata: Optional[Map[StringType, StringType]]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
    def getClientMetadata: ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("clientMetadata", clientMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminConfirmSignUpRequest
  ) extends zio.aws.cognitoidentityprovider.model.AdminConfirmSignUpRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
    override val clientMetadata: Optional[Map[StringType, StringType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientMetadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: StringType) -> (value: StringType)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminConfirmSignUpRequest
  ): zio.aws.cognitoidentityprovider.model.AdminConfirmSignUpRequest.ReadOnly =
    new Wrapper(impl)
}
