package zio.aws.cognitoidentityprovider.model
import zio.aws.cognitoidentityprovider.model.primitives.{
  StringType,
  BooleanType,
  DateType,
  UsernameType
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class AdminGetUserResponse(
    username: UsernameType,
    userAttributes: Optional[
      Iterable[zio.aws.cognitoidentityprovider.model.AttributeType]
    ] = Optional.Absent,
    userCreateDate: Optional[DateType] = Optional.Absent,
    userLastModifiedDate: Optional[DateType] = Optional.Absent,
    enabled: Optional[BooleanType] = Optional.Absent,
    userStatus: Optional[zio.aws.cognitoidentityprovider.model.UserStatusType] =
      Optional.Absent,
    mfaOptions: Optional[
      Iterable[zio.aws.cognitoidentityprovider.model.MFAOptionType]
    ] = Optional.Absent,
    preferredMfaSetting: Optional[StringType] = Optional.Absent,
    userMFASettingList: Optional[Iterable[StringType]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserResponse = {
    import AdminGetUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserResponse
      .builder()
      .username(UsernameType.unwrap(username): java.lang.String)
      .optionallyWith(
        userAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userAttributes)
      .optionallyWith(
        userCreateDate.map(value => DateType.unwrap(value): Instant)
      )(_.userCreateDate)
      .optionallyWith(
        userLastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.userLastModifiedDate)
      .optionallyWith(
        enabled.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(userStatus.map(value => value.unwrap))(_.userStatus)
      .optionallyWith(
        mfaOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mfaOptions)
      .optionallyWith(
        preferredMfaSetting.map(value => value: java.lang.String)
      )(_.preferredMfaSetting)
      .optionallyWith(
        userMFASettingList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.userMFASettingList)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminGetUserResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminGetUserResponse
      .wrap(buildAwsValue())
}
object AdminGetUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.AdminGetUserResponse =
      zio.aws.cognitoidentityprovider.model.AdminGetUserResponse(
        username,
        userAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userCreateDate.map(value => value),
        userLastModifiedDate.map(value => value),
        enabled.map(value => value),
        userStatus.map(value => value),
        mfaOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        preferredMfaSetting.map(value => value),
        userMFASettingList.map(value => value)
      )
    def username: UsernameType
    def userAttributes: Optional[
      List[zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly]
    ]
    def userCreateDate: Optional[DateType]
    def userLastModifiedDate: Optional[DateType]
    def enabled: Optional[BooleanType]
    def userStatus
        : Optional[zio.aws.cognitoidentityprovider.model.UserStatusType]
    def mfaOptions: Optional[
      List[zio.aws.cognitoidentityprovider.model.MFAOptionType.ReadOnly]
    ]
    def preferredMfaSetting: Optional[StringType]
    def userMFASettingList: Optional[List[StringType]]
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
    def getUserAttributes: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly
    ]] = AwsError.unwrapOptionField("userAttributes", userAttributes)
    def getUserCreateDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("userCreateDate", userCreateDate)
    def getUserLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("userLastModifiedDate", userLastModifiedDate)
    def getEnabled: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getUserStatus: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserStatusType
    ] = AwsError.unwrapOptionField("userStatus", userStatus)
    def getMfaOptions: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.MFAOptionType.ReadOnly
    ]] = AwsError.unwrapOptionField("mfaOptions", mfaOptions)
    def getPreferredMfaSetting: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("preferredMfaSetting", preferredMfaSetting)
    def getUserMFASettingList: ZIO[Any, AwsError, List[StringType]] =
      AwsError.unwrapOptionField("userMFASettingList", userMFASettingList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserResponse
  ) extends zio.aws.cognitoidentityprovider.model.AdminGetUserResponse.ReadOnly {
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
    override val userAttributes: Optional[
      List[zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.userAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.AttributeType.wrap(item)
        }.toList
      )
    override val userCreateDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.userCreateDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val userLastModifiedDate: Optional[DateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userLastModifiedDate())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
        )
    override val enabled: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
      )
    override val userStatus
        : Optional[zio.aws.cognitoidentityprovider.model.UserStatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userStatus())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.UserStatusType.wrap(value)
        )
    override val mfaOptions: Optional[
      List[zio.aws.cognitoidentityprovider.model.MFAOptionType.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mfaOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.MFAOptionType.wrap(item)
        }.toList
      )
    override val preferredMfaSetting: Optional[StringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMfaSetting())
        .map(value => value: StringType)
    override val userMFASettingList: Optional[List[StringType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userMFASettingList())
        .map(value =>
          value.asScala.map { item =>
            item: StringType
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserResponse
  ): zio.aws.cognitoidentityprovider.model.AdminGetUserResponse.ReadOnly =
    new Wrapper(impl)
}
