package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  ImageFileType,
  CSSType,
  ClientIdType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class SetUiCustomizationRequest(
    userPoolId: UserPoolIdType,
    clientId: Optional[ClientIdType] = Optional.Absent,
    css: Optional[CSSType] = Optional.Absent,
    imageFile: Optional[ImageFileType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationRequest = {
    import SetUiCustomizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .optionallyWith(
        clientId.map(value => ClientIdType.unwrap(value): java.lang.String)
      )(_.clientId)
      .optionallyWith(
        css.map(value => CSSType.unwrap(value): java.lang.String)
      )(_.css)
      .optionallyWith(
        imageFile.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.imageFile)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.SetUiCustomizationRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.SetUiCustomizationRequest
      .wrap(buildAwsValue())
}
object SetUiCustomizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.SetUiCustomizationRequest =
      zio.aws.cognitoidentityprovider.model.SetUiCustomizationRequest(
        userPoolId,
        clientId.map(value => value),
        css.map(value => value),
        imageFile.map(value => value)
      )
    def userPoolId: UserPoolIdType
    def clientId: Optional[ClientIdType]
    def css: Optional[CSSType]
    def imageFile: Optional[ImageFileType]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getClientId: ZIO[Any, AwsError, ClientIdType] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getCss: ZIO[Any, AwsError, CSSType] =
      AwsError.unwrapOptionField("css", css)
    def getImageFile: ZIO[Any, AwsError, ImageFileType] =
      AwsError.unwrapOptionField("imageFile", imageFile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationRequest
  ) extends zio.aws.cognitoidentityprovider.model.SetUiCustomizationRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val clientId: Optional[ClientIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.clientId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ClientIdType(value)
      )
    override val css: Optional[CSSType] = zio.aws.core.internal
      .optionalFromNullable(impl.css())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.CSSType(value)
      )
    override val imageFile: Optional[ImageFileType] = zio.aws.core.internal
      .optionalFromNullable(impl.imageFile())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .ImageFileType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationRequest
  ): zio.aws.cognitoidentityprovider.model.SetUiCustomizationRequest.ReadOnly =
    new Wrapper(impl)
}
