package zio.aws.cognitoidentityprovider.model
import zio.aws.cognitoidentityprovider.model.primitives.{
  DateType,
  ProviderNameType
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ProviderDescription(
    providerName: Optional[ProviderNameType] = Optional.Absent,
    providerType: Optional[
      zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType
    ] = Optional.Absent,
    lastModifiedDate: Optional[DateType] = Optional.Absent,
    creationDate: Optional[DateType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ProviderDescription = {
    import ProviderDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ProviderDescription
      .builder()
      .optionallyWith(
        providerName.map(value =>
          ProviderNameType.unwrap(value): java.lang.String
        )
      )(_.providerName)
      .optionallyWith(providerType.map(value => value.unwrap))(_.providerType)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ProviderDescription.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ProviderDescription
      .wrap(buildAwsValue())
}
object ProviderDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ProviderDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.ProviderDescription =
      zio.aws.cognitoidentityprovider.model.ProviderDescription(
        providerName.map(value => value),
        providerType.map(value => value),
        lastModifiedDate.map(value => value),
        creationDate.map(value => value)
      )
    def providerName: Optional[ProviderNameType]
    def providerType: Optional[
      zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType
    ]
    def lastModifiedDate: Optional[DateType]
    def creationDate: Optional[DateType]
    def getProviderName: ZIO[Any, AwsError, ProviderNameType] =
      AwsError.unwrapOptionField("providerName", providerName)
    def getProviderType: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType
    ] = AwsError.unwrapOptionField("providerType", providerType)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ProviderDescription
  ) extends zio.aws.cognitoidentityprovider.model.ProviderDescription.ReadOnly {
    override val providerName: Optional[ProviderNameType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providerName())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .ProviderNameType(value)
        )
    override val providerType: Optional[
      zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.providerType())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType
          .wrap(value)
      )
    override val lastModifiedDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val creationDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ProviderDescription
  ): zio.aws.cognitoidentityprovider.model.ProviderDescription.ReadOnly =
    new Wrapper(impl)
}
