package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType
import scala.jdk.CollectionConverters._
final case class SetUserPoolMfaConfigRequest(
    userPoolId: UserPoolIdType,
    smsMfaConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.SmsMfaConfigType
    ] = Optional.Absent,
    softwareTokenMfaConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaConfigType
    ] = Optional.Absent,
    mfaConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.UserPoolMfaType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigRequest = {
    import SetUserPoolMfaConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .optionallyWith(smsMfaConfiguration.map(value => value.buildAwsValue()))(
        _.smsMfaConfiguration
      )
      .optionallyWith(
        softwareTokenMfaConfiguration.map(value => value.buildAwsValue())
      )(_.softwareTokenMfaConfiguration)
      .optionallyWith(mfaConfiguration.map(value => value.unwrap))(
        _.mfaConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.SetUserPoolMfaConfigRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.SetUserPoolMfaConfigRequest
      .wrap(buildAwsValue())
}
object SetUserPoolMfaConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.SetUserPoolMfaConfigRequest =
      zio.aws.cognitoidentityprovider.model.SetUserPoolMfaConfigRequest(
        userPoolId,
        smsMfaConfiguration.map(value => value.asEditable),
        softwareTokenMfaConfiguration.map(value => value.asEditable),
        mfaConfiguration.map(value => value)
      )
    def userPoolId: UserPoolIdType
    def smsMfaConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.SmsMfaConfigType.ReadOnly
    ]
    def softwareTokenMfaConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaConfigType.ReadOnly
    ]
    def mfaConfiguration
        : Optional[zio.aws.cognitoidentityprovider.model.UserPoolMfaType]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getSmsMfaConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.SmsMfaConfigType.ReadOnly
    ] = AwsError.unwrapOptionField("smsMfaConfiguration", smsMfaConfiguration)
    def getSoftwareTokenMfaConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaConfigType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "softwareTokenMfaConfiguration",
      softwareTokenMfaConfiguration
    )
    def getMfaConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserPoolMfaType
    ] = AwsError.unwrapOptionField("mfaConfiguration", mfaConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigRequest
  ) extends zio.aws.cognitoidentityprovider.model.SetUserPoolMfaConfigRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val smsMfaConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.SmsMfaConfigType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.smsMfaConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.SmsMfaConfigType.wrap(value)
      )
    override val softwareTokenMfaConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaConfigType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.softwareTokenMfaConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaConfigType
          .wrap(value)
      )
    override val mfaConfiguration
        : Optional[zio.aws.cognitoidentityprovider.model.UserPoolMfaType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mfaConfiguration())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.UserPoolMfaType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigRequest
  ): zio.aws.cognitoidentityprovider.model.SetUserPoolMfaConfigRequest.ReadOnly =
    new Wrapper(impl)
}
