package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  IdpIdentifierType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class GetIdentityProviderByIdentifierRequest(
    userPoolId: UserPoolIdType,
    idpIdentifier: IdpIdentifierType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierRequest = {
    import GetIdentityProviderByIdentifierRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .idpIdentifier(IdpIdentifierType.unwrap(idpIdentifier): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.GetIdentityProviderByIdentifierRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.GetIdentityProviderByIdentifierRequest
      .wrap(buildAwsValue())
}
object GetIdentityProviderByIdentifierRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.GetIdentityProviderByIdentifierRequest =
      zio.aws.cognitoidentityprovider.model
        .GetIdentityProviderByIdentifierRequest(userPoolId, idpIdentifier)
    def userPoolId: UserPoolIdType
    def idpIdentifier: IdpIdentifierType
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getIdpIdentifier: ZIO[Any, Nothing, IdpIdentifierType] =
      ZIO.succeed(idpIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierRequest
  ) extends zio.aws.cognitoidentityprovider.model.GetIdentityProviderByIdentifierRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val idpIdentifier: IdpIdentifierType =
      zio.aws.cognitoidentityprovider.model.primitives
        .IdpIdentifierType(impl.idpIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierRequest
  ): zio.aws.cognitoidentityprovider.model.GetIdentityProviderByIdentifierRequest.ReadOnly =
    new Wrapper(impl)
}
