package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.DomainType
import scala.jdk.CollectionConverters._
final case class DescribeUserPoolDomainRequest(domain: DomainType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainRequest = {
    import DescribeUserPoolDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainRequest
      .builder()
      .domain(DomainType.unwrap(domain): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.DescribeUserPoolDomainRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.DescribeUserPoolDomainRequest
      .wrap(buildAwsValue())
}
object DescribeUserPoolDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.DescribeUserPoolDomainRequest =
      zio.aws.cognitoidentityprovider.model
        .DescribeUserPoolDomainRequest(domain)
    def domain: DomainType
    def getDomain: ZIO[Any, Nothing, DomainType] = ZIO.succeed(domain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainRequest
  ) extends zio.aws.cognitoidentityprovider.model.DescribeUserPoolDomainRequest.ReadOnly {
    override val domain: DomainType =
      zio.aws.cognitoidentityprovider.model.primitives.DomainType(impl.domain())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainRequest
  ): zio.aws.cognitoidentityprovider.model.DescribeUserPoolDomainRequest.ReadOnly =
    new Wrapper(impl)
}
