package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait AdvancedSecurityModeType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.AdvancedSecurityModeType
}
object AdvancedSecurityModeType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.AdvancedSecurityModeType
  ): zio.aws.cognitoidentityprovider.model.AdvancedSecurityModeType =
    value match {
      case software.amazon.awssdk.services.cognitoidentityprovider.model.AdvancedSecurityModeType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.AdvancedSecurityModeType.OFF =>
        val r = OFF
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.AdvancedSecurityModeType.AUDIT =>
        val r = AUDIT
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.AdvancedSecurityModeType.ENFORCED =>
        val r = ENFORCED
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.AdvancedSecurityModeType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AdvancedSecurityModeType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdvancedSecurityModeType.UNKNOWN_TO_SDK_VERSION
  }
  case object OFF
      extends zio.aws.cognitoidentityprovider.model.AdvancedSecurityModeType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AdvancedSecurityModeType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdvancedSecurityModeType.OFF
  }
  case object AUDIT
      extends zio.aws.cognitoidentityprovider.model.AdvancedSecurityModeType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AdvancedSecurityModeType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdvancedSecurityModeType.AUDIT
  }
  case object ENFORCED
      extends zio.aws.cognitoidentityprovider.model.AdvancedSecurityModeType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AdvancedSecurityModeType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AdvancedSecurityModeType.ENFORCED
  }
}
