package zio.aws.cognitoidentityprovider.model
import zio.aws.cognitoidentityprovider.model.primitives.{
  PaginationKey,
  QueryLimit,
  UserPoolIdType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListUserPoolClientsRequest(
    userPoolId: UserPoolIdType,
    maxResults: Optional[QueryLimit] = Optional.Absent,
    nextToken: Optional[PaginationKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest = {
    import ListUserPoolClientsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => QueryLimit.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationKey.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ListUserPoolClientsRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ListUserPoolClientsRequest
      .wrap(buildAwsValue())
}
object ListUserPoolClientsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ListUserPoolClientsRequest =
      zio.aws.cognitoidentityprovider.model.ListUserPoolClientsRequest(
        userPoolId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def userPoolId: UserPoolIdType
    def maxResults: Optional[QueryLimit]
    def nextToken: Optional[PaginationKey]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getMaxResults: ZIO[Any, AwsError, QueryLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationKey] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest
  ) extends zio.aws.cognitoidentityprovider.model.ListUserPoolClientsRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val maxResults: Optional[QueryLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.QueryLimit(value)
      )
    override val nextToken: Optional[PaginationKey] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.PaginationKey(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest
  ): zio.aws.cognitoidentityprovider.model.ListUserPoolClientsRequest.ReadOnly =
    new Wrapper(impl)
}
