package zio.aws.cognitoidentityprovider.model
import zio.aws.cognitoidentityprovider.model.primitives.{
  ArnType,
  CompletionMessageType,
  DateType,
  UserPoolIdType,
  PreSignedUrlType,
  LongType,
  UserImportJobIdType,
  UserImportJobNameType
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class UserImportJobType(
    jobName: Optional[UserImportJobNameType] = Optional.Absent,
    jobId: Optional[UserImportJobIdType] = Optional.Absent,
    userPoolId: Optional[UserPoolIdType] = Optional.Absent,
    preSignedUrl: Optional[PreSignedUrlType] = Optional.Absent,
    creationDate: Optional[DateType] = Optional.Absent,
    startDate: Optional[DateType] = Optional.Absent,
    completionDate: Optional[DateType] = Optional.Absent,
    status: Optional[
      zio.aws.cognitoidentityprovider.model.UserImportJobStatusType
    ] = Optional.Absent,
    cloudWatchLogsRoleArn: Optional[ArnType] = Optional.Absent,
    importedUsers: Optional[LongType] = Optional.Absent,
    skippedUsers: Optional[LongType] = Optional.Absent,
    failedUsers: Optional[LongType] = Optional.Absent,
    completionMessage: Optional[CompletionMessageType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.UserImportJobType = {
    import UserImportJobType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserImportJobType
      .builder()
      .optionallyWith(
        jobName.map(value =>
          UserImportJobNameType.unwrap(value): java.lang.String
        )
      )(_.jobName)
      .optionallyWith(
        jobId.map(value => UserImportJobIdType.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        userPoolId.map(value => UserPoolIdType.unwrap(value): java.lang.String)
      )(_.userPoolId)
      .optionallyWith(
        preSignedUrl.map(value =>
          PreSignedUrlType.unwrap(value): java.lang.String
        )
      )(_.preSignedUrl)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(startDate.map(value => DateType.unwrap(value): Instant))(
        _.startDate
      )
      .optionallyWith(
        completionDate.map(value => DateType.unwrap(value): Instant)
      )(_.completionDate)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        cloudWatchLogsRoleArn.map(value =>
          ArnType.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogsRoleArn)
      .optionallyWith(
        importedUsers.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.importedUsers)
      .optionallyWith(
        skippedUsers.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.skippedUsers)
      .optionallyWith(
        failedUsers.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.failedUsers)
      .optionallyWith(
        completionMessage.map(value =>
          CompletionMessageType.unwrap(value): java.lang.String
        )
      )(_.completionMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.UserImportJobType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.UserImportJobType
      .wrap(buildAwsValue())
}
object UserImportJobType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserImportJobType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.UserImportJobType =
      zio.aws.cognitoidentityprovider.model.UserImportJobType(
        jobName.map(value => value),
        jobId.map(value => value),
        userPoolId.map(value => value),
        preSignedUrl.map(value => value),
        creationDate.map(value => value),
        startDate.map(value => value),
        completionDate.map(value => value),
        status.map(value => value),
        cloudWatchLogsRoleArn.map(value => value),
        importedUsers.map(value => value),
        skippedUsers.map(value => value),
        failedUsers.map(value => value),
        completionMessage.map(value => value)
      )
    def jobName: Optional[UserImportJobNameType]
    def jobId: Optional[UserImportJobIdType]
    def userPoolId: Optional[UserPoolIdType]
    def preSignedUrl: Optional[PreSignedUrlType]
    def creationDate: Optional[DateType]
    def startDate: Optional[DateType]
    def completionDate: Optional[DateType]
    def status: Optional[
      zio.aws.cognitoidentityprovider.model.UserImportJobStatusType
    ]
    def cloudWatchLogsRoleArn: Optional[ArnType]
    def importedUsers: Optional[LongType]
    def skippedUsers: Optional[LongType]
    def failedUsers: Optional[LongType]
    def completionMessage: Optional[CompletionMessageType]
    def getJobName: ZIO[Any, AwsError, UserImportJobNameType] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getJobId: ZIO[Any, AwsError, UserImportJobIdType] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getUserPoolId: ZIO[Any, AwsError, UserPoolIdType] =
      AwsError.unwrapOptionField("userPoolId", userPoolId)
    def getPreSignedUrl: ZIO[Any, AwsError, PreSignedUrlType] =
      AwsError.unwrapOptionField("preSignedUrl", preSignedUrl)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getStartDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getCompletionDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("completionDate", completionDate)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserImportJobStatusType
    ] = AwsError.unwrapOptionField("status", status)
    def getCloudWatchLogsRoleArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("cloudWatchLogsRoleArn", cloudWatchLogsRoleArn)
    def getImportedUsers: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("importedUsers", importedUsers)
    def getSkippedUsers: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("skippedUsers", skippedUsers)
    def getFailedUsers: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("failedUsers", failedUsers)
    def getCompletionMessage: ZIO[Any, AwsError, CompletionMessageType] =
      AwsError.unwrapOptionField("completionMessage", completionMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserImportJobType
  ) extends zio.aws.cognitoidentityprovider.model.UserImportJobType.ReadOnly {
    override val jobName: Optional[UserImportJobNameType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobName())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .UserImportJobNameType(value)
        )
    override val jobId: Optional[UserImportJobIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .UserImportJobIdType(value)
      )
    override val userPoolId: Optional[UserPoolIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.userPoolId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType(value)
      )
    override val preSignedUrl: Optional[PreSignedUrlType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preSignedUrl())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .PreSignedUrlType(value)
        )
    override val creationDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val startDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.startDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val completionDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.completionDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val status: Optional[
      zio.aws.cognitoidentityprovider.model.UserImportJobStatusType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserImportJobStatusType
          .wrap(value)
      )
    override val cloudWatchLogsRoleArn: Optional[ArnType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogsRoleArn())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
        )
    override val importedUsers: Optional[LongType] = zio.aws.core.internal
      .optionalFromNullable(impl.importedUsers())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.LongType(value)
      )
    override val skippedUsers: Optional[LongType] = zio.aws.core.internal
      .optionalFromNullable(impl.skippedUsers())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.LongType(value)
      )
    override val failedUsers: Optional[LongType] = zio.aws.core.internal
      .optionalFromNullable(impl.failedUsers())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.LongType(value)
      )
    override val completionMessage: Optional[CompletionMessageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completionMessage())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .CompletionMessageType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserImportJobType
  ): zio.aws.cognitoidentityprovider.model.UserImportJobType.ReadOnly =
    new Wrapper(impl)
}
