package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait VerifySoftwareTokenResponseType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenResponseType
}
object VerifySoftwareTokenResponseType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenResponseType
  ): zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenResponseType =
    value match {
      case software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenResponseType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenResponseType.SUCCESS =>
        val r = SUCCESS
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenResponseType.ERROR =>
        val r = ERROR
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenResponseType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenResponseType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenResponseType.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCESS
      extends zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenResponseType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenResponseType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenResponseType.SUCCESS
  }
  case object ERROR
      extends zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenResponseType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenResponseType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenResponseType.ERROR
  }
}
