package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.PaginationKeyType
import scala.jdk.CollectionConverters._
final case class ListUserImportJobsResponse(
    userImportJobs: Optional[
      Iterable[zio.aws.cognitoidentityprovider.model.UserImportJobType]
    ] = Optional.Absent,
    paginationToken: Optional[PaginationKeyType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsResponse = {
    import ListUserImportJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsResponse
      .builder()
      .optionallyWith(
        userImportJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userImportJobs)
      .optionallyWith(
        paginationToken.map(value =>
          PaginationKeyType.unwrap(value): java.lang.String
        )
      )(_.paginationToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ListUserImportJobsResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ListUserImportJobsResponse
      .wrap(buildAwsValue())
}
object ListUserImportJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ListUserImportJobsResponse =
      zio.aws.cognitoidentityprovider.model.ListUserImportJobsResponse(
        userImportJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        paginationToken.map(value => value)
      )
    def userImportJobs: Optional[
      List[zio.aws.cognitoidentityprovider.model.UserImportJobType.ReadOnly]
    ]
    def paginationToken: Optional[PaginationKeyType]
    def getUserImportJobs: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.UserImportJobType.ReadOnly
    ]] = AwsError.unwrapOptionField("userImportJobs", userImportJobs)
    def getPaginationToken: ZIO[Any, AwsError, PaginationKeyType] =
      AwsError.unwrapOptionField("paginationToken", paginationToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsResponse
  ) extends zio.aws.cognitoidentityprovider.model.ListUserImportJobsResponse.ReadOnly {
    override val userImportJobs: Optional[
      List[zio.aws.cognitoidentityprovider.model.UserImportJobType.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.userImportJobs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.UserImportJobType.wrap(item)
        }.toList
      )
    override val paginationToken: Optional[PaginationKeyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.paginationToken())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .PaginationKeyType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsResponse
  ): zio.aws.cognitoidentityprovider.model.ListUserImportJobsResponse.ReadOnly =
    new Wrapper(impl)
}
