package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeUserPoolResponse(
    userPool: Optional[zio.aws.cognitoidentityprovider.model.UserPoolType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolResponse = {
    import DescribeUserPoolResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolResponse
      .builder()
      .optionallyWith(userPool.map(value => value.buildAwsValue()))(_.userPool)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.DescribeUserPoolResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.DescribeUserPoolResponse
      .wrap(buildAwsValue())
}
object DescribeUserPoolResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.DescribeUserPoolResponse =
      zio.aws.cognitoidentityprovider.model
        .DescribeUserPoolResponse(userPool.map(value => value.asEditable))
    def userPool
        : Optional[zio.aws.cognitoidentityprovider.model.UserPoolType.ReadOnly]
    def getUserPool: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserPoolType.ReadOnly
    ] = AwsError.unwrapOptionField("userPool", userPool)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolResponse
  ) extends zio.aws.cognitoidentityprovider.model.DescribeUserPoolResponse.ReadOnly {
    override val userPool: Optional[
      zio.aws.cognitoidentityprovider.model.UserPoolType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.userPool())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserPoolType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolResponse
  ): zio.aws.cognitoidentityprovider.model.DescribeUserPoolResponse.ReadOnly =
    new Wrapper(impl)
}
