package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait TimeUnitsType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.TimeUnitsType
}
object TimeUnitsType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.TimeUnitsType
  ): zio.aws.cognitoidentityprovider.model.TimeUnitsType = value match {
    case software.amazon.awssdk.services.cognitoidentityprovider.model.TimeUnitsType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.TimeUnitsType.SECONDS =>
      val r = seconds
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.TimeUnitsType.MINUTES =>
      val r = minutes
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.TimeUnitsType.HOURS =>
      val r = hours
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.TimeUnitsType.DAYS =>
      val r = days
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.TimeUnitsType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.TimeUnitsType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.TimeUnitsType.UNKNOWN_TO_SDK_VERSION
  }
  case object seconds
      extends zio.aws.cognitoidentityprovider.model.TimeUnitsType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.TimeUnitsType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.TimeUnitsType.SECONDS
  }
  case object minutes
      extends zio.aws.cognitoidentityprovider.model.TimeUnitsType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.TimeUnitsType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.TimeUnitsType.MINUTES
  }
  case object hours
      extends zio.aws.cognitoidentityprovider.model.TimeUnitsType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.TimeUnitsType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.TimeUnitsType.HOURS
  }
  case object days extends zio.aws.cognitoidentityprovider.model.TimeUnitsType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.TimeUnitsType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.TimeUnitsType.DAYS
  }
}
