package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  PasswordType,
  UserPoolIdType,
  ForceAliasCreation,
  UsernameType,
  StringType
}
import scala.jdk.CollectionConverters._
final case class AdminCreateUserRequest(
    userPoolId: UserPoolIdType,
    username: UsernameType,
    userAttributes: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.AttributeType]
    ] = None,
    validationData: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.AttributeType]
    ] = None,
    temporaryPassword: Option[PasswordType] = None,
    forceAliasCreation: Option[ForceAliasCreation] = None,
    messageAction: Option[
      zio.aws.cognitoidentityprovider.model.MessageActionType
    ] = None,
    desiredDeliveryMediums: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.DeliveryMediumType]
    ] = None,
    clientMetadata: Option[Map[StringType, StringType]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserRequest = {
    import AdminCreateUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .username(UsernameType.unwrap(username): java.lang.String)
      .optionallyWith(
        userAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userAttributes)
      .optionallyWith(
        validationData.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validationData)
      .optionallyWith(
        temporaryPassword.map(value =>
          PasswordType.unwrap(value): java.lang.String
        )
      )(_.temporaryPassword)
      .optionallyWith(
        forceAliasCreation.map(value =>
          ForceAliasCreation.unwrap(value): java.lang.Boolean
        )
      )(_.forceAliasCreation)
      .optionallyWith(messageAction.map(value => value.unwrap))(_.messageAction)
      .optionallyWith(
        desiredDeliveryMediums.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.desiredDeliveryMediumsWithStrings)
      .optionallyWith(
        clientMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.clientMetadata)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminCreateUserRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminCreateUserRequest
      .wrap(buildAwsValue())
}
object AdminCreateUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminCreateUserRequest =
      zio.aws.cognitoidentityprovider.model.AdminCreateUserRequest(
        userPoolId,
        username,
        userAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        validationData.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        temporaryPassword.map(value => value),
        forceAliasCreation.map(value => value),
        messageAction.map(value => value),
        desiredDeliveryMediums.map(value => value),
        clientMetadata.map(value => value)
      )
    def userPoolId: UserPoolIdType
    def username: UsernameType
    def userAttributes: Option[
      List[zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly]
    ]
    def validationData: Option[
      List[zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly]
    ]
    def temporaryPassword: Option[PasswordType]
    def forceAliasCreation: Option[ForceAliasCreation]
    def messageAction
        : Option[zio.aws.cognitoidentityprovider.model.MessageActionType]
    def desiredDeliveryMediums
        : Option[List[zio.aws.cognitoidentityprovider.model.DeliveryMediumType]]
    def clientMetadata: Option[Map[StringType, StringType]]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
    def getUserAttributes: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly
    ]] = AwsError.unwrapOptionField("userAttributes", userAttributes)
    def getValidationData: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly
    ]] = AwsError.unwrapOptionField("validationData", validationData)
    def getTemporaryPassword: ZIO[Any, AwsError, PasswordType] =
      AwsError.unwrapOptionField("temporaryPassword", temporaryPassword)
    def getForceAliasCreation: ZIO[Any, AwsError, ForceAliasCreation] =
      AwsError.unwrapOptionField("forceAliasCreation", forceAliasCreation)
    def getMessageAction: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.MessageActionType
    ] = AwsError.unwrapOptionField("messageAction", messageAction)
    def getDesiredDeliveryMediums: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.DeliveryMediumType
    ]] = AwsError.unwrapOptionField(
      "desiredDeliveryMediums",
      desiredDeliveryMediums
    )
    def getClientMetadata: ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("clientMetadata", clientMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserRequest
  ) extends zio.aws.cognitoidentityprovider.model.AdminCreateUserRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
    override val userAttributes: Option[
      List[zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly]
    ] = scala
      .Option(impl.userAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.AttributeType.wrap(item)
        }.toList
      )
    override val validationData: Option[
      List[zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly]
    ] = scala
      .Option(impl.validationData())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.AttributeType.wrap(item)
        }.toList
      )
    override val temporaryPassword: Option[PasswordType] = scala
      .Option(impl.temporaryPassword())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.PasswordType(value)
      )
    override val forceAliasCreation: Option[ForceAliasCreation] = scala
      .Option(impl.forceAliasCreation())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .ForceAliasCreation(value)
      )
    override val messageAction
        : Option[zio.aws.cognitoidentityprovider.model.MessageActionType] =
      scala
        .Option(impl.messageAction())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.MessageActionType.wrap(value)
        )
    override val desiredDeliveryMediums: Option[
      List[zio.aws.cognitoidentityprovider.model.DeliveryMediumType]
    ] = scala
      .Option(impl.desiredDeliveryMediums())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.DeliveryMediumType.wrap(item)
        }.toList
      )
    override val clientMetadata: Option[Map[StringType, StringType]] = scala
      .Option(impl.clientMetadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: StringType) -> (value: StringType)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserRequest
  ): zio.aws.cognitoidentityprovider.model.AdminCreateUserRequest.ReadOnly =
    new Wrapper(impl)
}
