package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  EmailVerificationMessageType,
  SmsVerificationMessageType,
  EmailVerificationSubjectType,
  EmailVerificationSubjectByLinkType,
  EmailVerificationMessageByLinkType
}
import scala.jdk.CollectionConverters._
final case class VerificationMessageTemplateType(
    smsMessage: Option[SmsVerificationMessageType] = None,
    emailMessage: Option[EmailVerificationMessageType] = None,
    emailSubject: Option[EmailVerificationSubjectType] = None,
    emailMessageByLink: Option[EmailVerificationMessageByLinkType] = None,
    emailSubjectByLink: Option[EmailVerificationSubjectByLinkType] = None,
    defaultEmailOption: Option[
      zio.aws.cognitoidentityprovider.model.DefaultEmailOptionType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.VerificationMessageTemplateType = {
    import VerificationMessageTemplateType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.VerificationMessageTemplateType
      .builder()
      .optionallyWith(
        smsMessage.map(value =>
          SmsVerificationMessageType.unwrap(value): java.lang.String
        )
      )(_.smsMessage)
      .optionallyWith(
        emailMessage.map(value =>
          EmailVerificationMessageType.unwrap(value): java.lang.String
        )
      )(_.emailMessage)
      .optionallyWith(
        emailSubject.map(value =>
          EmailVerificationSubjectType.unwrap(value): java.lang.String
        )
      )(_.emailSubject)
      .optionallyWith(
        emailMessageByLink.map(value =>
          EmailVerificationMessageByLinkType.unwrap(value): java.lang.String
        )
      )(_.emailMessageByLink)
      .optionallyWith(
        emailSubjectByLink.map(value =>
          EmailVerificationSubjectByLinkType.unwrap(value): java.lang.String
        )
      )(_.emailSubjectByLink)
      .optionallyWith(defaultEmailOption.map(value => value.unwrap))(
        _.defaultEmailOption
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType
      .wrap(buildAwsValue())
}
object VerificationMessageTemplateType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.VerificationMessageTemplateType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType =
      zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType(
        smsMessage.map(value => value),
        emailMessage.map(value => value),
        emailSubject.map(value => value),
        emailMessageByLink.map(value => value),
        emailSubjectByLink.map(value => value),
        defaultEmailOption.map(value => value)
      )
    def smsMessage: Option[SmsVerificationMessageType]
    def emailMessage: Option[EmailVerificationMessageType]
    def emailSubject: Option[EmailVerificationSubjectType]
    def emailMessageByLink: Option[EmailVerificationMessageByLinkType]
    def emailSubjectByLink: Option[EmailVerificationSubjectByLinkType]
    def defaultEmailOption
        : Option[zio.aws.cognitoidentityprovider.model.DefaultEmailOptionType]
    def getSmsMessage: ZIO[Any, AwsError, SmsVerificationMessageType] =
      AwsError.unwrapOptionField("smsMessage", smsMessage)
    def getEmailMessage: ZIO[Any, AwsError, EmailVerificationMessageType] =
      AwsError.unwrapOptionField("emailMessage", emailMessage)
    def getEmailSubject: ZIO[Any, AwsError, EmailVerificationSubjectType] =
      AwsError.unwrapOptionField("emailSubject", emailSubject)
    def getEmailMessageByLink
        : ZIO[Any, AwsError, EmailVerificationMessageByLinkType] =
      AwsError.unwrapOptionField("emailMessageByLink", emailMessageByLink)
    def getEmailSubjectByLink
        : ZIO[Any, AwsError, EmailVerificationSubjectByLinkType] =
      AwsError.unwrapOptionField("emailSubjectByLink", emailSubjectByLink)
    def getDefaultEmailOption: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.DefaultEmailOptionType
    ] = AwsError.unwrapOptionField("defaultEmailOption", defaultEmailOption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.VerificationMessageTemplateType
  ) extends zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType.ReadOnly {
    override val smsMessage: Option[SmsVerificationMessageType] = scala
      .Option(impl.smsMessage())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .SmsVerificationMessageType(value)
      )
    override val emailMessage: Option[EmailVerificationMessageType] = scala
      .Option(impl.emailMessage())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .EmailVerificationMessageType(value)
      )
    override val emailSubject: Option[EmailVerificationSubjectType] = scala
      .Option(impl.emailSubject())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .EmailVerificationSubjectType(value)
      )
    override val emailMessageByLink
        : Option[EmailVerificationMessageByLinkType] = scala
      .Option(impl.emailMessageByLink())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .EmailVerificationMessageByLinkType(value)
      )
    override val emailSubjectByLink
        : Option[EmailVerificationSubjectByLinkType] = scala
      .Option(impl.emailSubjectByLink())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .EmailVerificationSubjectByLinkType(value)
      )
    override val defaultEmailOption
        : Option[zio.aws.cognitoidentityprovider.model.DefaultEmailOptionType] =
      scala
        .Option(impl.defaultEmailOption())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.DefaultEmailOptionType
            .wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.VerificationMessageTemplateType
  ): zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType.ReadOnly =
    new Wrapper(impl)
}
