package zio.aws.cognitoidentityprovider.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  TemporaryPasswordValidityDaysType,
  BooleanType,
  PasswordPolicyMinLengthType
}
import scala.jdk.CollectionConverters._
final case class PasswordPolicyType(
    minimumLength: Option[PasswordPolicyMinLengthType] = None,
    requireUppercase: Option[BooleanType] = None,
    requireLowercase: Option[BooleanType] = None,
    requireNumbers: Option[BooleanType] = None,
    requireSymbols: Option[BooleanType] = None,
    temporaryPasswordValidityDays: Option[TemporaryPasswordValidityDaysType] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.PasswordPolicyType = {
    import PasswordPolicyType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.PasswordPolicyType
      .builder()
      .optionallyWith(
        minimumLength.map(value =>
          PasswordPolicyMinLengthType.unwrap(value): Integer
        )
      )(_.minimumLength)
      .optionallyWith(
        requireUppercase.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.requireUppercase)
      .optionallyWith(
        requireLowercase.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.requireLowercase)
      .optionallyWith(
        requireNumbers.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.requireNumbers)
      .optionallyWith(
        requireSymbols.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.requireSymbols)
      .optionallyWith(
        temporaryPasswordValidityDays.map(value =>
          TemporaryPasswordValidityDaysType.unwrap(value): Integer
        )
      )(_.temporaryPasswordValidityDays)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.PasswordPolicyType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.PasswordPolicyType
      .wrap(buildAwsValue())
}
object PasswordPolicyType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.PasswordPolicyType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.PasswordPolicyType =
      zio.aws.cognitoidentityprovider.model.PasswordPolicyType(
        minimumLength.map(value => value),
        requireUppercase.map(value => value),
        requireLowercase.map(value => value),
        requireNumbers.map(value => value),
        requireSymbols.map(value => value),
        temporaryPasswordValidityDays.map(value => value)
      )
    def minimumLength: Option[PasswordPolicyMinLengthType]
    def requireUppercase: Option[BooleanType]
    def requireLowercase: Option[BooleanType]
    def requireNumbers: Option[BooleanType]
    def requireSymbols: Option[BooleanType]
    def temporaryPasswordValidityDays: Option[TemporaryPasswordValidityDaysType]
    def getMinimumLength: ZIO[Any, AwsError, PasswordPolicyMinLengthType] =
      AwsError.unwrapOptionField("minimumLength", minimumLength)
    def getRequireUppercase: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("requireUppercase", requireUppercase)
    def getRequireLowercase: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("requireLowercase", requireLowercase)
    def getRequireNumbers: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("requireNumbers", requireNumbers)
    def getRequireSymbols: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("requireSymbols", requireSymbols)
    def getTemporaryPasswordValidityDays
        : ZIO[Any, AwsError, TemporaryPasswordValidityDaysType] =
      AwsError.unwrapOptionField(
        "temporaryPasswordValidityDays",
        temporaryPasswordValidityDays
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.PasswordPolicyType
  ) extends zio.aws.cognitoidentityprovider.model.PasswordPolicyType.ReadOnly {
    override val minimumLength: Option[PasswordPolicyMinLengthType] = scala
      .Option(impl.minimumLength())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .PasswordPolicyMinLengthType(value)
      )
    override val requireUppercase: Option[BooleanType] = scala
      .Option(impl.requireUppercase())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
      )
    override val requireLowercase: Option[BooleanType] = scala
      .Option(impl.requireLowercase())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
      )
    override val requireNumbers: Option[BooleanType] = scala
      .Option(impl.requireNumbers())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
      )
    override val requireSymbols: Option[BooleanType] = scala
      .Option(impl.requireSymbols())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
      )
    override val temporaryPasswordValidityDays
        : Option[TemporaryPasswordValidityDaysType] = scala
      .Option(impl.temporaryPasswordValidityDays())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .TemporaryPasswordValidityDaysType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.PasswordPolicyType
  ): zio.aws.cognitoidentityprovider.model.PasswordPolicyType.ReadOnly =
    new Wrapper(impl)
}
