package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  StringType,
  SoftwareTokenMFAUserCodeType,
  SessionType,
  TokenModelType
}
import scala.jdk.CollectionConverters._
final case class VerifySoftwareTokenRequest(
    accessToken: Option[TokenModelType] = None,
    session: Option[SessionType] = None,
    userCode: SoftwareTokenMFAUserCodeType,
    friendlyDeviceName: Option[StringType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenRequest = {
    import VerifySoftwareTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenRequest
      .builder()
      .optionallyWith(
        accessToken.map(value => TokenModelType.unwrap(value): java.lang.String)
      )(_.accessToken)
      .optionallyWith(
        session.map(value => SessionType.unwrap(value): java.lang.String)
      )(_.session)
      .userCode(SoftwareTokenMFAUserCodeType.unwrap(userCode): java.lang.String)
      .optionallyWith(friendlyDeviceName.map(value => value: java.lang.String))(
        _.friendlyDeviceName
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenRequest
      .wrap(buildAwsValue())
}
object VerifySoftwareTokenRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenRequest =
      zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenRequest(
        accessToken.map(value => value),
        session.map(value => value),
        userCode,
        friendlyDeviceName.map(value => value)
      )
    def accessToken: Option[TokenModelType]
    def session: Option[SessionType]
    def userCode: SoftwareTokenMFAUserCodeType
    def friendlyDeviceName: Option[StringType]
    def getAccessToken: ZIO[Any, AwsError, TokenModelType] =
      AwsError.unwrapOptionField("accessToken", accessToken)
    def getSession: ZIO[Any, AwsError, SessionType] =
      AwsError.unwrapOptionField("session", session)
    def getUserCode: ZIO[Any, Nothing, SoftwareTokenMFAUserCodeType] =
      ZIO.succeed(userCode)
    def getFriendlyDeviceName: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("friendlyDeviceName", friendlyDeviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenRequest
  ) extends zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenRequest.ReadOnly {
    override val accessToken: Option[TokenModelType] = scala
      .Option(impl.accessToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.TokenModelType(value)
      )
    override val session: Option[SessionType] = scala
      .Option(impl.session())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.SessionType(value)
      )
    override val userCode: SoftwareTokenMFAUserCodeType =
      zio.aws.cognitoidentityprovider.model.primitives
        .SoftwareTokenMFAUserCodeType(impl.userCode())
    override val friendlyDeviceName: Option[StringType] =
      scala.Option(impl.friendlyDeviceName()).map(value => value: StringType)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenRequest
  ): zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenRequest.ReadOnly =
    new Wrapper(impl)
}
