package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  StringType,
  BooleanType
}
import scala.jdk.CollectionConverters._
final case class SignUpResponse(
    userConfirmed: BooleanType,
    codeDeliveryDetails: Option[
      zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType
    ] = None,
    userSub: StringType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpResponse = {
    import SignUpResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpResponse
      .builder()
      .userConfirmed(BooleanType.unwrap(userConfirmed): java.lang.Boolean)
      .optionallyWith(codeDeliveryDetails.map(value => value.buildAwsValue()))(
        _.codeDeliveryDetails
      )
      .userSub(userSub: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.SignUpResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.SignUpResponse.wrap(buildAwsValue())
}
object SignUpResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.SignUpResponse =
      zio.aws.cognitoidentityprovider.model.SignUpResponse(
        userConfirmed,
        codeDeliveryDetails.map(value => value.asEditable),
        userSub
      )
    def userConfirmed: BooleanType
    def codeDeliveryDetails: Option[
      zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType.ReadOnly
    ]
    def userSub: StringType
    def getUserConfirmed: ZIO[Any, Nothing, BooleanType] =
      ZIO.succeed(userConfirmed)
    def getCodeDeliveryDetails: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType.ReadOnly
    ] = AwsError.unwrapOptionField("codeDeliveryDetails", codeDeliveryDetails)
    def getUserSub: ZIO[Any, Nothing, StringType] = ZIO.succeed(userSub)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpResponse
  ) extends zio.aws.cognitoidentityprovider.model.SignUpResponse.ReadOnly {
    override val userConfirmed: BooleanType =
      zio.aws.cognitoidentityprovider.model.primitives
        .BooleanType(impl.userConfirmed())
    override val codeDeliveryDetails: Option[
      zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType.ReadOnly
    ] = scala
      .Option(impl.codeDeliveryDetails())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType
          .wrap(value)
      )
    override val userSub: StringType = impl.userSub(): StringType
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpResponse
  ): zio.aws.cognitoidentityprovider.model.SignUpResponse.ReadOnly =
    new Wrapper(impl)
}
