package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait OAuthFlowType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.OAuthFlowType
}
object OAuthFlowType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.OAuthFlowType
  ): zio.aws.cognitoidentityprovider.model.OAuthFlowType = value match {
    case software.amazon.awssdk.services.cognitoidentityprovider.model.OAuthFlowType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.OAuthFlowType.CODE =>
      val r = code
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.OAuthFlowType.IMPLICIT =>
      val r = `implicit`
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.OAuthFlowType.CLIENT_CREDENTIALS =>
      val r = client_credentials
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.OAuthFlowType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.OAuthFlowType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.OAuthFlowType.UNKNOWN_TO_SDK_VERSION
  }
  case object code extends zio.aws.cognitoidentityprovider.model.OAuthFlowType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.OAuthFlowType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.OAuthFlowType.CODE
  }
  case object `implicit`
      extends zio.aws.cognitoidentityprovider.model.OAuthFlowType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.OAuthFlowType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.OAuthFlowType.IMPLICIT
  }
  case object client_credentials
      extends zio.aws.cognitoidentityprovider.model.OAuthFlowType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.OAuthFlowType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.OAuthFlowType.CLIENT_CREDENTIALS
  }
}
