package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.SearchPaginationTokenType
import scala.jdk.CollectionConverters._
final case class ListUsersResponse(
    users: Option[Iterable[zio.aws.cognitoidentityprovider.model.UserType]] =
      None,
    paginationToken: Option[SearchPaginationTokenType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersResponse = {
    import ListUsersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersResponse
      .builder()
      .optionallyWith(
        users.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.users)
      .optionallyWith(
        paginationToken.map(value =>
          SearchPaginationTokenType.unwrap(value): java.lang.String
        )
      )(_.paginationToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ListUsersResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ListUsersResponse
      .wrap(buildAwsValue())
}
object ListUsersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.ListUsersResponse =
      zio.aws.cognitoidentityprovider.model.ListUsersResponse(
        users.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        paginationToken.map(value => value)
      )
    def users
        : Option[List[zio.aws.cognitoidentityprovider.model.UserType.ReadOnly]]
    def paginationToken: Option[SearchPaginationTokenType]
    def getUsers: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.UserType.ReadOnly
    ]] = AwsError.unwrapOptionField("users", users)
    def getPaginationToken: ZIO[Any, AwsError, SearchPaginationTokenType] =
      AwsError.unwrapOptionField("paginationToken", paginationToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersResponse
  ) extends zio.aws.cognitoidentityprovider.model.ListUsersResponse.ReadOnly {
    override val users: Option[
      List[zio.aws.cognitoidentityprovider.model.UserType.ReadOnly]
    ] = scala
      .Option(impl.users())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.UserType.wrap(item)
        }.toList
      )
    override val paginationToken: Option[SearchPaginationTokenType] = scala
      .Option(impl.paginationToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .SearchPaginationTokenType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersResponse
  ): zio.aws.cognitoidentityprovider.model.ListUsersResponse.ReadOnly =
    new Wrapper(impl)
}
