package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CompromisedCredentialsRiskConfigurationType(
    eventFilter: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.EventFilterType]
    ] = None,
    actions: zio.aws.cognitoidentityprovider.model.CompromisedCredentialsActionsType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType = {
    import CompromisedCredentialsRiskConfigurationType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType
      .builder()
      .optionallyWith(
        eventFilter.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.eventFilterWithStrings)
      .actions(actions.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType
      .wrap(buildAwsValue())
}
object CompromisedCredentialsRiskConfigurationType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType =
      zio.aws.cognitoidentityprovider.model
        .CompromisedCredentialsRiskConfigurationType(
          eventFilter.map(value => value),
          actions.asEditable
        )
    def eventFilter
        : Option[List[zio.aws.cognitoidentityprovider.model.EventFilterType]]
    def actions
        : zio.aws.cognitoidentityprovider.model.CompromisedCredentialsActionsType.ReadOnly
    def getEventFilter: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.EventFilterType
    ]] = AwsError.unwrapOptionField("eventFilter", eventFilter)
    def getActions: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.CompromisedCredentialsActionsType.ReadOnly
    ] = ZIO.succeed(actions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType
  ) extends zio.aws.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType.ReadOnly {
    override val eventFilter
        : Option[List[zio.aws.cognitoidentityprovider.model.EventFilterType]] =
      scala
        .Option(impl.eventFilter())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cognitoidentityprovider.model.EventFilterType.wrap(item)
          }.toList
        )
    override val actions
        : zio.aws.cognitoidentityprovider.model.CompromisedCredentialsActionsType.ReadOnly =
      zio.aws.cognitoidentityprovider.model.CompromisedCredentialsActionsType
        .wrap(impl.actions())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType
  ): zio.aws.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType.ReadOnly =
    new Wrapper(impl)
}
