package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  SessionType,
  TokenModelType
}
import scala.jdk.CollectionConverters._
final case class AssociateSoftwareTokenRequest(
    accessToken: Option[TokenModelType] = None,
    session: Option[SessionType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenRequest = {
    import AssociateSoftwareTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenRequest
      .builder()
      .optionallyWith(
        accessToken.map(value => TokenModelType.unwrap(value): java.lang.String)
      )(_.accessToken)
      .optionallyWith(
        session.map(value => SessionType.unwrap(value): java.lang.String)
      )(_.session)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AssociateSoftwareTokenRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AssociateSoftwareTokenRequest
      .wrap(buildAwsValue())
}
object AssociateSoftwareTokenRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AssociateSoftwareTokenRequest =
      zio.aws.cognitoidentityprovider.model.AssociateSoftwareTokenRequest(
        accessToken.map(value => value),
        session.map(value => value)
      )
    def accessToken: Option[TokenModelType]
    def session: Option[SessionType]
    def getAccessToken: ZIO[Any, AwsError, TokenModelType] =
      AwsError.unwrapOptionField("accessToken", accessToken)
    def getSession: ZIO[Any, AwsError, SessionType] =
      AwsError.unwrapOptionField("session", session)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenRequest
  ) extends zio.aws.cognitoidentityprovider.model.AssociateSoftwareTokenRequest.ReadOnly {
    override val accessToken: Option[TokenModelType] = scala
      .Option(impl.accessToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.TokenModelType(value)
      )
    override val session: Option[SessionType] = scala
      .Option(impl.session())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.SessionType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenRequest
  ): zio.aws.cognitoidentityprovider.model.AssociateSoftwareTokenRequest.ReadOnly =
    new Wrapper(impl)
}
