package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.PaginationKey
import scala.jdk.CollectionConverters._
final case class AdminListGroupsForUserResponse(
    groups: Option[Iterable[zio.aws.cognitoidentityprovider.model.GroupType]] =
      None,
    nextToken: Option[PaginationKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserResponse = {
    import AdminListGroupsForUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserResponse
      .builder()
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(
        nextToken.map(value => PaginationKey.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminListGroupsForUserResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminListGroupsForUserResponse
      .wrap(buildAwsValue())
}
object AdminListGroupsForUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminListGroupsForUserResponse =
      zio.aws.cognitoidentityprovider.model.AdminListGroupsForUserResponse(
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def groups
        : Option[List[zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly]]
    def nextToken: Option[PaginationKey]
    def getGroups: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly
    ]] = AwsError.unwrapOptionField("groups", groups)
    def getNextToken: ZIO[Any, AwsError, PaginationKey] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserResponse
  ) extends zio.aws.cognitoidentityprovider.model.AdminListGroupsForUserResponse.ReadOnly {
    override val groups: Option[
      List[zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly]
    ] = scala
      .Option(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.GroupType.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationKey] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.PaginationKey(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserResponse
  ): zio.aws.cognitoidentityprovider.model.AdminListGroupsForUserResponse.ReadOnly =
    new Wrapper(impl)
}
