package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{StringType, ArnType}
import scala.jdk.CollectionConverters._
final case class SmsConfigurationType(
    snsCallerArn: ArnType,
    externalId: Option[StringType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.SmsConfigurationType = {
    import SmsConfigurationType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.SmsConfigurationType
      .builder()
      .snsCallerArn(ArnType.unwrap(snsCallerArn): java.lang.String)
      .optionallyWith(
        externalId.map(value => StringType.unwrap(value): java.lang.String)
      )(_.externalId)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.SmsConfigurationType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.SmsConfigurationType
      .wrap(buildAwsValue())
}
object SmsConfigurationType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.SmsConfigurationType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.SmsConfigurationType =
      zio.aws.cognitoidentityprovider.model
        .SmsConfigurationType(snsCallerArn, externalId.map(value => value))
    def snsCallerArn: ArnType
    def externalId: Option[StringType]
    def getSnsCallerArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(snsCallerArn)
    def getExternalId: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("externalId", externalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SmsConfigurationType
  ) extends zio.aws.cognitoidentityprovider.model.SmsConfigurationType.ReadOnly {
    override val snsCallerArn: ArnType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ArnType(impl.snsCallerArn())
    override val externalId: Option[StringType] = scala
      .Option(impl.externalId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.StringType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SmsConfigurationType
  ): zio.aws.cognitoidentityprovider.model.SmsConfigurationType.ReadOnly =
    new Wrapper(impl)
}
