package zio.aws.cognitoidentityprovider.model
import zio.aws.cognitoidentityprovider.model.primitives.{
  ArnType,
  EmailVerificationMessageType,
  SmsVerificationMessageType,
  EmailVerificationSubjectType,
  UserPoolNameType,
  DateType,
  UserPoolIdType,
  TagKeysType,
  IntegerType,
  StringType,
  TagValueType,
  DomainType
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UserPoolType(
    id: Option[UserPoolIdType] = None,
    name: Option[UserPoolNameType] = None,
    policies: Option[zio.aws.cognitoidentityprovider.model.UserPoolPolicyType] =
      None,
    lambdaConfig: Option[
      zio.aws.cognitoidentityprovider.model.LambdaConfigType
    ] = None,
    status: Option[zio.aws.cognitoidentityprovider.model.StatusType] = None,
    lastModifiedDate: Option[DateType] = None,
    creationDate: Option[DateType] = None,
    schemaAttributes: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.SchemaAttributeType]
    ] = None,
    autoVerifiedAttributes: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.VerifiedAttributeType]
    ] = None,
    aliasAttributes: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.AliasAttributeType]
    ] = None,
    usernameAttributes: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.UsernameAttributeType]
    ] = None,
    smsVerificationMessage: Option[SmsVerificationMessageType] = None,
    emailVerificationMessage: Option[EmailVerificationMessageType] = None,
    emailVerificationSubject: Option[EmailVerificationSubjectType] = None,
    verificationMessageTemplate: Option[
      zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType
    ] = None,
    smsAuthenticationMessage: Option[SmsVerificationMessageType] = None,
    mfaConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.UserPoolMfaType
    ] = None,
    deviceConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.DeviceConfigurationType
    ] = None,
    estimatedNumberOfUsers: Option[IntegerType] = None,
    emailConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.EmailConfigurationType
    ] = None,
    smsConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.SmsConfigurationType
    ] = None,
    userPoolTags: Option[Map[TagKeysType, TagValueType]] = None,
    smsConfigurationFailure: Option[StringType] = None,
    emailConfigurationFailure: Option[StringType] = None,
    domain: Option[DomainType] = None,
    customDomain: Option[DomainType] = None,
    adminCreateUserConfig: Option[
      zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType
    ] = None,
    userPoolAddOns: Option[
      zio.aws.cognitoidentityprovider.model.UserPoolAddOnsType
    ] = None,
    usernameConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.UsernameConfigurationType
    ] = None,
    arn: Option[ArnType] = None,
    accountRecoverySetting: Option[
      zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolType = {
    import UserPoolType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolType
      .builder()
      .optionallyWith(
        id.map(value => UserPoolIdType.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => UserPoolNameType.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(policies.map(value => value.buildAwsValue()))(_.policies)
      .optionallyWith(lambdaConfig.map(value => value.buildAwsValue()))(
        _.lambdaConfig
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        schemaAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.schemaAttributes)
      .optionallyWith(
        autoVerifiedAttributes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.autoVerifiedAttributesWithStrings)
      .optionallyWith(
        aliasAttributes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.aliasAttributesWithStrings)
      .optionallyWith(
        usernameAttributes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.usernameAttributesWithStrings)
      .optionallyWith(
        smsVerificationMessage.map(value =>
          SmsVerificationMessageType.unwrap(value): java.lang.String
        )
      )(_.smsVerificationMessage)
      .optionallyWith(
        emailVerificationMessage.map(value =>
          EmailVerificationMessageType.unwrap(value): java.lang.String
        )
      )(_.emailVerificationMessage)
      .optionallyWith(
        emailVerificationSubject.map(value =>
          EmailVerificationSubjectType.unwrap(value): java.lang.String
        )
      )(_.emailVerificationSubject)
      .optionallyWith(
        verificationMessageTemplate.map(value => value.buildAwsValue())
      )(_.verificationMessageTemplate)
      .optionallyWith(
        smsAuthenticationMessage.map(value =>
          SmsVerificationMessageType.unwrap(value): java.lang.String
        )
      )(_.smsAuthenticationMessage)
      .optionallyWith(mfaConfiguration.map(value => value.unwrap))(
        _.mfaConfiguration
      )
      .optionallyWith(deviceConfiguration.map(value => value.buildAwsValue()))(
        _.deviceConfiguration
      )
      .optionallyWith(
        estimatedNumberOfUsers.map(value => IntegerType.unwrap(value): Integer)
      )(_.estimatedNumberOfUsers)
      .optionallyWith(emailConfiguration.map(value => value.buildAwsValue()))(
        _.emailConfiguration
      )
      .optionallyWith(smsConfiguration.map(value => value.buildAwsValue()))(
        _.smsConfiguration
      )
      .optionallyWith(
        userPoolTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKeysType.unwrap(key): java.lang.String) -> (TagValueType
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.userPoolTags)
      .optionallyWith(
        smsConfigurationFailure.map(value =>
          StringType.unwrap(value): java.lang.String
        )
      )(_.smsConfigurationFailure)
      .optionallyWith(
        emailConfigurationFailure.map(value =>
          StringType.unwrap(value): java.lang.String
        )
      )(_.emailConfigurationFailure)
      .optionallyWith(
        domain.map(value => DomainType.unwrap(value): java.lang.String)
      )(_.domain)
      .optionallyWith(
        customDomain.map(value => DomainType.unwrap(value): java.lang.String)
      )(_.customDomain)
      .optionallyWith(
        adminCreateUserConfig.map(value => value.buildAwsValue())
      )(_.adminCreateUserConfig)
      .optionallyWith(userPoolAddOns.map(value => value.buildAwsValue()))(
        _.userPoolAddOns
      )
      .optionallyWith(
        usernameConfiguration.map(value => value.buildAwsValue())
      )(_.usernameConfiguration)
      .optionallyWith(
        arn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        accountRecoverySetting.map(value => value.buildAwsValue())
      )(_.accountRecoverySetting)
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentityprovider.model.UserPoolType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.UserPoolType.wrap(buildAwsValue())
}
object UserPoolType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.UserPoolType =
      zio.aws.cognitoidentityprovider.model.UserPoolType(
        id.map(value => value),
        name.map(value => value),
        policies.map(value => value.asEditable),
        lambdaConfig.map(value => value.asEditable),
        status.map(value => value),
        lastModifiedDate.map(value => value),
        creationDate.map(value => value),
        schemaAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        autoVerifiedAttributes.map(value => value),
        aliasAttributes.map(value => value),
        usernameAttributes.map(value => value),
        smsVerificationMessage.map(value => value),
        emailVerificationMessage.map(value => value),
        emailVerificationSubject.map(value => value),
        verificationMessageTemplate.map(value => value.asEditable),
        smsAuthenticationMessage.map(value => value),
        mfaConfiguration.map(value => value),
        deviceConfiguration.map(value => value.asEditable),
        estimatedNumberOfUsers.map(value => value),
        emailConfiguration.map(value => value.asEditable),
        smsConfiguration.map(value => value.asEditable),
        userPoolTags.map(value => value),
        smsConfigurationFailure.map(value => value),
        emailConfigurationFailure.map(value => value),
        domain.map(value => value),
        customDomain.map(value => value),
        adminCreateUserConfig.map(value => value.asEditable),
        userPoolAddOns.map(value => value.asEditable),
        usernameConfiguration.map(value => value.asEditable),
        arn.map(value => value),
        accountRecoverySetting.map(value => value.asEditable)
      )
    def id: Option[UserPoolIdType]
    def name: Option[UserPoolNameType]
    def policies: Option[
      zio.aws.cognitoidentityprovider.model.UserPoolPolicyType.ReadOnly
    ]
    def lambdaConfig: Option[
      zio.aws.cognitoidentityprovider.model.LambdaConfigType.ReadOnly
    ]
    def status: Option[zio.aws.cognitoidentityprovider.model.StatusType]
    def lastModifiedDate: Option[DateType]
    def creationDate: Option[DateType]
    def schemaAttributes: Option[
      List[zio.aws.cognitoidentityprovider.model.SchemaAttributeType.ReadOnly]
    ]
    def autoVerifiedAttributes: Option[
      List[zio.aws.cognitoidentityprovider.model.VerifiedAttributeType]
    ]
    def aliasAttributes
        : Option[List[zio.aws.cognitoidentityprovider.model.AliasAttributeType]]
    def usernameAttributes: Option[
      List[zio.aws.cognitoidentityprovider.model.UsernameAttributeType]
    ]
    def smsVerificationMessage: Option[SmsVerificationMessageType]
    def emailVerificationMessage: Option[EmailVerificationMessageType]
    def emailVerificationSubject: Option[EmailVerificationSubjectType]
    def verificationMessageTemplate: Option[
      zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType.ReadOnly
    ]
    def smsAuthenticationMessage: Option[SmsVerificationMessageType]
    def mfaConfiguration
        : Option[zio.aws.cognitoidentityprovider.model.UserPoolMfaType]
    def deviceConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.DeviceConfigurationType.ReadOnly
    ]
    def estimatedNumberOfUsers: Option[IntegerType]
    def emailConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.EmailConfigurationType.ReadOnly
    ]
    def smsConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.SmsConfigurationType.ReadOnly
    ]
    def userPoolTags: Option[Map[TagKeysType, TagValueType]]
    def smsConfigurationFailure: Option[StringType]
    def emailConfigurationFailure: Option[StringType]
    def domain: Option[DomainType]
    def customDomain: Option[DomainType]
    def adminCreateUserConfig: Option[
      zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType.ReadOnly
    ]
    def userPoolAddOns: Option[
      zio.aws.cognitoidentityprovider.model.UserPoolAddOnsType.ReadOnly
    ]
    def usernameConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.UsernameConfigurationType.ReadOnly
    ]
    def arn: Option[ArnType]
    def accountRecoverySetting: Option[
      zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType.ReadOnly
    ]
    def getId: ZIO[Any, AwsError, UserPoolIdType] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, UserPoolNameType] =
      AwsError.unwrapOptionField("name", name)
    def getPolicies: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserPoolPolicyType.ReadOnly
    ] = AwsError.unwrapOptionField("policies", policies)
    def getLambdaConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.LambdaConfigType.ReadOnly
    ] = AwsError.unwrapOptionField("lambdaConfig", lambdaConfig)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.cognitoidentityprovider.model.StatusType] =
      AwsError.unwrapOptionField("status", status)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getSchemaAttributes: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.SchemaAttributeType.ReadOnly
    ]] = AwsError.unwrapOptionField("schemaAttributes", schemaAttributes)
    def getAutoVerifiedAttributes: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.VerifiedAttributeType
    ]] = AwsError.unwrapOptionField(
      "autoVerifiedAttributes",
      autoVerifiedAttributes
    )
    def getAliasAttributes: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.AliasAttributeType
    ]] = AwsError.unwrapOptionField("aliasAttributes", aliasAttributes)
    def getUsernameAttributes: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.UsernameAttributeType
    ]] = AwsError.unwrapOptionField("usernameAttributes", usernameAttributes)
    def getSmsVerificationMessage
        : ZIO[Any, AwsError, SmsVerificationMessageType] = AwsError
      .unwrapOptionField("smsVerificationMessage", smsVerificationMessage)
    def getEmailVerificationMessage
        : ZIO[Any, AwsError, EmailVerificationMessageType] = AwsError
      .unwrapOptionField("emailVerificationMessage", emailVerificationMessage)
    def getEmailVerificationSubject
        : ZIO[Any, AwsError, EmailVerificationSubjectType] = AwsError
      .unwrapOptionField("emailVerificationSubject", emailVerificationSubject)
    def getVerificationMessageTemplate: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "verificationMessageTemplate",
      verificationMessageTemplate
    )
    def getSmsAuthenticationMessage
        : ZIO[Any, AwsError, SmsVerificationMessageType] = AwsError
      .unwrapOptionField("smsAuthenticationMessage", smsAuthenticationMessage)
    def getMfaConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserPoolMfaType
    ] = AwsError.unwrapOptionField("mfaConfiguration", mfaConfiguration)
    def getDeviceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.DeviceConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField("deviceConfiguration", deviceConfiguration)
    def getEstimatedNumberOfUsers: ZIO[Any, AwsError, IntegerType] = AwsError
      .unwrapOptionField("estimatedNumberOfUsers", estimatedNumberOfUsers)
    def getEmailConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.EmailConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField("emailConfiguration", emailConfiguration)
    def getSmsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.SmsConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField("smsConfiguration", smsConfiguration)
    def getUserPoolTags: ZIO[Any, AwsError, Map[TagKeysType, TagValueType]] =
      AwsError.unwrapOptionField("userPoolTags", userPoolTags)
    def getSmsConfigurationFailure: ZIO[Any, AwsError, StringType] = AwsError
      .unwrapOptionField("smsConfigurationFailure", smsConfigurationFailure)
    def getEmailConfigurationFailure: ZIO[Any, AwsError, StringType] = AwsError
      .unwrapOptionField("emailConfigurationFailure", emailConfigurationFailure)
    def getDomain: ZIO[Any, AwsError, DomainType] =
      AwsError.unwrapOptionField("domain", domain)
    def getCustomDomain: ZIO[Any, AwsError, DomainType] =
      AwsError.unwrapOptionField("customDomain", customDomain)
    def getAdminCreateUserConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType.ReadOnly
    ] =
      AwsError.unwrapOptionField("adminCreateUserConfig", adminCreateUserConfig)
    def getUserPoolAddOns: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserPoolAddOnsType.ReadOnly
    ] = AwsError.unwrapOptionField("userPoolAddOns", userPoolAddOns)
    def getUsernameConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UsernameConfigurationType.ReadOnly
    ] =
      AwsError.unwrapOptionField("usernameConfiguration", usernameConfiguration)
    def getArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("arn", arn)
    def getAccountRecoverySetting: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "accountRecoverySetting",
      accountRecoverySetting
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolType
  ) extends zio.aws.cognitoidentityprovider.model.UserPoolType.ReadOnly {
    override val id: Option[UserPoolIdType] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType(value)
      )
    override val name: Option[UserPoolNameType] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UserPoolNameType(value)
      )
    override val policies: Option[
      zio.aws.cognitoidentityprovider.model.UserPoolPolicyType.ReadOnly
    ] = scala
      .Option(impl.policies())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserPoolPolicyType.wrap(value)
      )
    override val lambdaConfig: Option[
      zio.aws.cognitoidentityprovider.model.LambdaConfigType.ReadOnly
    ] = scala
      .Option(impl.lambdaConfig())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.LambdaConfigType.wrap(value)
      )
    override val status
        : Option[zio.aws.cognitoidentityprovider.model.StatusType] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.StatusType.wrap(value)
      )
    override val lastModifiedDate: Option[DateType] = scala
      .Option(impl.lastModifiedDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val creationDate: Option[DateType] = scala
      .Option(impl.creationDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val schemaAttributes: Option[
      List[zio.aws.cognitoidentityprovider.model.SchemaAttributeType.ReadOnly]
    ] = scala
      .Option(impl.schemaAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.SchemaAttributeType.wrap(item)
        }.toList
      )
    override val autoVerifiedAttributes: Option[
      List[zio.aws.cognitoidentityprovider.model.VerifiedAttributeType]
    ] = scala
      .Option(impl.autoVerifiedAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.VerifiedAttributeType.wrap(item)
        }.toList
      )
    override val aliasAttributes: Option[
      List[zio.aws.cognitoidentityprovider.model.AliasAttributeType]
    ] = scala
      .Option(impl.aliasAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.AliasAttributeType.wrap(item)
        }.toList
      )
    override val usernameAttributes: Option[
      List[zio.aws.cognitoidentityprovider.model.UsernameAttributeType]
    ] = scala
      .Option(impl.usernameAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.UsernameAttributeType.wrap(item)
        }.toList
      )
    override val smsVerificationMessage: Option[SmsVerificationMessageType] =
      scala
        .Option(impl.smsVerificationMessage())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .SmsVerificationMessageType(value)
        )
    override val emailVerificationMessage
        : Option[EmailVerificationMessageType] = scala
      .Option(impl.emailVerificationMessage())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .EmailVerificationMessageType(value)
      )
    override val emailVerificationSubject
        : Option[EmailVerificationSubjectType] = scala
      .Option(impl.emailVerificationSubject())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .EmailVerificationSubjectType(value)
      )
    override val verificationMessageTemplate: Option[
      zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType.ReadOnly
    ] = scala
      .Option(impl.verificationMessageTemplate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType
          .wrap(value)
      )
    override val smsAuthenticationMessage: Option[SmsVerificationMessageType] =
      scala
        .Option(impl.smsAuthenticationMessage())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .SmsVerificationMessageType(value)
        )
    override val mfaConfiguration
        : Option[zio.aws.cognitoidentityprovider.model.UserPoolMfaType] = scala
      .Option(impl.mfaConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserPoolMfaType.wrap(value)
      )
    override val deviceConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.DeviceConfigurationType.ReadOnly
    ] = scala
      .Option(impl.deviceConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.DeviceConfigurationType
          .wrap(value)
      )
    override val estimatedNumberOfUsers: Option[IntegerType] = scala
      .Option(impl.estimatedNumberOfUsers())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.IntegerType(value)
      )
    override val emailConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.EmailConfigurationType.ReadOnly
    ] = scala
      .Option(impl.emailConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.EmailConfigurationType.wrap(value)
      )
    override val smsConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.SmsConfigurationType.ReadOnly
    ] = scala
      .Option(impl.smsConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.SmsConfigurationType.wrap(value)
      )
    override val userPoolTags: Option[Map[TagKeysType, TagValueType]] = scala
      .Option(impl.userPoolTags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.cognitoidentityprovider.model.primitives.TagKeysType(
              key
            ) -> zio.aws.cognitoidentityprovider.model.primitives
              .TagValueType(value)
          })
          .toMap
      )
    override val smsConfigurationFailure: Option[StringType] = scala
      .Option(impl.smsConfigurationFailure())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.StringType(value)
      )
    override val emailConfigurationFailure: Option[StringType] = scala
      .Option(impl.emailConfigurationFailure())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.StringType(value)
      )
    override val domain: Option[DomainType] = scala
      .Option(impl.domain())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DomainType(value)
      )
    override val customDomain: Option[DomainType] = scala
      .Option(impl.customDomain())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DomainType(value)
      )
    override val adminCreateUserConfig: Option[
      zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType.ReadOnly
    ] = scala
      .Option(impl.adminCreateUserConfig())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType
          .wrap(value)
      )
    override val userPoolAddOns: Option[
      zio.aws.cognitoidentityprovider.model.UserPoolAddOnsType.ReadOnly
    ] = scala
      .Option(impl.userPoolAddOns())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserPoolAddOnsType.wrap(value)
      )
    override val usernameConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.UsernameConfigurationType.ReadOnly
    ] = scala
      .Option(impl.usernameConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UsernameConfigurationType
          .wrap(value)
      )
    override val arn: Option[ArnType] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val accountRecoverySetting: Option[
      zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType.ReadOnly
    ] = scala
      .Option(impl.accountRecoverySetting())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolType
  ): zio.aws.cognitoidentityprovider.model.UserPoolType.ReadOnly = new Wrapper(
    impl
  )
}
