package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StopUserImportJobResponse(
    userImportJob: Option[
      zio.aws.cognitoidentityprovider.model.UserImportJobType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobResponse = {
    import StopUserImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobResponse
      .builder()
      .optionallyWith(userImportJob.map(value => value.buildAwsValue()))(
        _.userImportJob
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.StopUserImportJobResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.StopUserImportJobResponse
      .wrap(buildAwsValue())
}
object StopUserImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.StopUserImportJobResponse =
      zio.aws.cognitoidentityprovider.model
        .StopUserImportJobResponse(userImportJob.map(value => value.asEditable))
    def userImportJob: Option[
      zio.aws.cognitoidentityprovider.model.UserImportJobType.ReadOnly
    ]
    def getUserImportJob: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserImportJobType.ReadOnly
    ] = AwsError.unwrapOptionField("userImportJob", userImportJob)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobResponse
  ) extends zio.aws.cognitoidentityprovider.model.StopUserImportJobResponse.ReadOnly {
    override val userImportJob: Option[
      zio.aws.cognitoidentityprovider.model.UserImportJobType.ReadOnly
    ] = scala
      .Option(impl.userImportJob())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserImportJobType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobResponse
  ): zio.aws.cognitoidentityprovider.model.StopUserImportJobResponse.ReadOnly =
    new Wrapper(impl)
}
