package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.BooleanType
import scala.jdk.CollectionConverters._
final case class SoftwareTokenMfaConfigType(
    enabled: Option[BooleanType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.SoftwareTokenMfaConfigType = {
    import SoftwareTokenMfaConfigType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.SoftwareTokenMfaConfigType
      .builder()
      .optionallyWith(
        enabled.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaConfigType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaConfigType
      .wrap(buildAwsValue())
}
object SoftwareTokenMfaConfigType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.SoftwareTokenMfaConfigType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaConfigType =
      zio.aws.cognitoidentityprovider.model
        .SoftwareTokenMfaConfigType(enabled.map(value => value))
    def enabled: Option[BooleanType]
    def getEnabled: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SoftwareTokenMfaConfigType
  ) extends zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaConfigType.ReadOnly {
    override val enabled: Option[BooleanType] = scala
      .Option(impl.enabled())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SoftwareTokenMfaConfigType
  ): zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaConfigType.ReadOnly =
    new Wrapper(impl)
}
