package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  DeviceKeyType,
  UsernameType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class AdminForgetDeviceRequest(
    userPoolId: UserPoolIdType,
    username: UsernameType,
    deviceKey: DeviceKeyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminForgetDeviceRequest = {
    import AdminForgetDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminForgetDeviceRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .username(UsernameType.unwrap(username): java.lang.String)
      .deviceKey(DeviceKeyType.unwrap(deviceKey): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminForgetDeviceRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminForgetDeviceRequest
      .wrap(buildAwsValue())
}
object AdminForgetDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminForgetDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminForgetDeviceRequest =
      zio.aws.cognitoidentityprovider.model
        .AdminForgetDeviceRequest(userPoolId, username, deviceKey)
    def userPoolId: UserPoolIdType
    def username: UsernameType
    def deviceKey: DeviceKeyType
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
    def getDeviceKey: ZIO[Any, Nothing, DeviceKeyType] = ZIO.succeed(deviceKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminForgetDeviceRequest
  ) extends zio.aws.cognitoidentityprovider.model.AdminForgetDeviceRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
    override val deviceKey: DeviceKeyType =
      zio.aws.cognitoidentityprovider.model.primitives
        .DeviceKeyType(impl.deviceKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminForgetDeviceRequest
  ): zio.aws.cognitoidentityprovider.model.AdminForgetDeviceRequest.ReadOnly =
    new Wrapper(impl)
}
