package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.PaginationKeyType
import scala.jdk.CollectionConverters._
final case class ListUserPoolsResponse(
    userPools: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType]
    ] = None,
    nextToken: Option[PaginationKeyType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse = {
    import ListUserPoolsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse
      .builder()
      .optionallyWith(
        userPools.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userPools)
      .optionallyWith(
        nextToken.map(value =>
          PaginationKeyType.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ListUserPoolsResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ListUserPoolsResponse
      .wrap(buildAwsValue())
}
object ListUserPoolsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ListUserPoolsResponse =
      zio.aws.cognitoidentityprovider.model.ListUserPoolsResponse(
        userPools.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def userPools: Option[List[
      zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType.ReadOnly
    ]]
    def nextToken: Option[PaginationKeyType]
    def getUserPools: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType.ReadOnly
    ]] = AwsError.unwrapOptionField("userPools", userPools)
    def getNextToken: ZIO[Any, AwsError, PaginationKeyType] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse
  ) extends zio.aws.cognitoidentityprovider.model.ListUserPoolsResponse.ReadOnly {
    override val userPools: Option[List[
      zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType.ReadOnly
    ]] = scala
      .Option(impl.userPools())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType
            .wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationKeyType] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .PaginationKeyType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse
  ): zio.aws.cognitoidentityprovider.model.ListUserPoolsResponse.ReadOnly =
    new Wrapper(impl)
}
