package zio.aws.cognitoidentityprovider.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  SearchPaginationTokenType,
  QueryLimitType,
  TokenModelType
}
import scala.jdk.CollectionConverters._
final case class ListDevicesRequest(
    accessToken: TokenModelType,
    limit: Option[QueryLimitType] = None,
    paginationToken: Option[SearchPaginationTokenType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesRequest = {
    import ListDevicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesRequest
      .builder()
      .accessToken(TokenModelType.unwrap(accessToken): java.lang.String)
      .optionallyWith(
        limit.map(value => QueryLimitType.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        paginationToken.map(value =>
          SearchPaginationTokenType.unwrap(value): java.lang.String
        )
      )(_.paginationToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ListDevicesRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ListDevicesRequest
      .wrap(buildAwsValue())
}
object ListDevicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.ListDevicesRequest =
      zio.aws.cognitoidentityprovider.model.ListDevicesRequest(
        accessToken,
        limit.map(value => value),
        paginationToken.map(value => value)
      )
    def accessToken: TokenModelType
    def limit: Option[QueryLimitType]
    def paginationToken: Option[SearchPaginationTokenType]
    def getAccessToken: ZIO[Any, Nothing, TokenModelType] =
      ZIO.succeed(accessToken)
    def getLimit: ZIO[Any, AwsError, QueryLimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getPaginationToken: ZIO[Any, AwsError, SearchPaginationTokenType] =
      AwsError.unwrapOptionField("paginationToken", paginationToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesRequest
  ) extends zio.aws.cognitoidentityprovider.model.ListDevicesRequest.ReadOnly {
    override val accessToken: TokenModelType =
      zio.aws.cognitoidentityprovider.model.primitives
        .TokenModelType(impl.accessToken())
    override val limit: Option[QueryLimitType] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.QueryLimitType(value)
      )
    override val paginationToken: Option[SearchPaginationTokenType] = scala
      .Option(impl.paginationToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .SearchPaginationTokenType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesRequest
  ): zio.aws.cognitoidentityprovider.model.ListDevicesRequest.ReadOnly =
    new Wrapper(impl)
}
