package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateGroupResponse(
    group: Option[zio.aws.cognitoidentityprovider.model.GroupType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupResponse = {
    import CreateGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupResponse
      .builder()
      .optionallyWith(group.map(value => value.buildAwsValue()))(_.group)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.CreateGroupResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.CreateGroupResponse
      .wrap(buildAwsValue())
}
object CreateGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.CreateGroupResponse =
      zio.aws.cognitoidentityprovider.model
        .CreateGroupResponse(group.map(value => value.asEditable))
    def group: Option[zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly]
    def getGroup: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly
    ] = AwsError.unwrapOptionField("group", group)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupResponse
  ) extends zio.aws.cognitoidentityprovider.model.CreateGroupResponse.ReadOnly {
    override val group
        : Option[zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly] =
      scala
        .Option(impl.group())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.GroupType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupResponse
  ): zio.aws.cognitoidentityprovider.model.CreateGroupResponse.ReadOnly =
    new Wrapper(impl)
}
