package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.SearchPaginationTokenType
import scala.jdk.CollectionConverters._
final case class AdminListDevicesResponse(
    devices: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.DeviceType]
    ] = None,
    paginationToken: Option[SearchPaginationTokenType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesResponse = {
    import AdminListDevicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesResponse
      .builder()
      .optionallyWith(
        devices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.devices)
      .optionallyWith(
        paginationToken.map(value =>
          SearchPaginationTokenType.unwrap(value): java.lang.String
        )
      )(_.paginationToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminListDevicesResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminListDevicesResponse
      .wrap(buildAwsValue())
}
object AdminListDevicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminListDevicesResponse =
      zio.aws.cognitoidentityprovider.model.AdminListDevicesResponse(
        devices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        paginationToken.map(value => value)
      )
    def devices: Option[
      List[zio.aws.cognitoidentityprovider.model.DeviceType.ReadOnly]
    ]
    def paginationToken: Option[SearchPaginationTokenType]
    def getDevices: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.DeviceType.ReadOnly
    ]] = AwsError.unwrapOptionField("devices", devices)
    def getPaginationToken: ZIO[Any, AwsError, SearchPaginationTokenType] =
      AwsError.unwrapOptionField("paginationToken", paginationToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesResponse
  ) extends zio.aws.cognitoidentityprovider.model.AdminListDevicesResponse.ReadOnly {
    override val devices: Option[
      List[zio.aws.cognitoidentityprovider.model.DeviceType.ReadOnly]
    ] = scala
      .Option(impl.devices())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.DeviceType.wrap(item)
        }.toList
      )
    override val paginationToken: Option[SearchPaginationTokenType] = scala
      .Option(impl.paginationToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .SearchPaginationTokenType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesResponse
  ): zio.aws.cognitoidentityprovider.model.AdminListDevicesResponse.ReadOnly =
    new Wrapper(impl)
}
