package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  ClientIdType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class SetRiskConfigurationRequest(
    userPoolId: UserPoolIdType,
    clientId: Option[ClientIdType] = None,
    compromisedCredentialsRiskConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType
    ] = None,
    accountTakeoverRiskConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType
    ] = None,
    riskExceptionConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.RiskExceptionConfigurationType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationRequest = {
    import SetRiskConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .optionallyWith(
        clientId.map(value => ClientIdType.unwrap(value): java.lang.String)
      )(_.clientId)
      .optionallyWith(
        compromisedCredentialsRiskConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.compromisedCredentialsRiskConfiguration)
      .optionallyWith(
        accountTakeoverRiskConfiguration.map(value => value.buildAwsValue())
      )(_.accountTakeoverRiskConfiguration)
      .optionallyWith(
        riskExceptionConfiguration.map(value => value.buildAwsValue())
      )(_.riskExceptionConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.SetRiskConfigurationRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.SetRiskConfigurationRequest
      .wrap(buildAwsValue())
}
object SetRiskConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.SetRiskConfigurationRequest =
      zio.aws.cognitoidentityprovider.model.SetRiskConfigurationRequest(
        userPoolId,
        clientId.map(value => value),
        compromisedCredentialsRiskConfiguration.map(value => value.asEditable),
        accountTakeoverRiskConfiguration.map(value => value.asEditable),
        riskExceptionConfiguration.map(value => value.asEditable)
      )
    def userPoolId: UserPoolIdType
    def clientId: Option[ClientIdType]
    def compromisedCredentialsRiskConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType.ReadOnly
    ]
    def accountTakeoverRiskConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType.ReadOnly
    ]
    def riskExceptionConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.RiskExceptionConfigurationType.ReadOnly
    ]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getClientId: ZIO[Any, AwsError, ClientIdType] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getCompromisedCredentialsRiskConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "compromisedCredentialsRiskConfiguration",
      compromisedCredentialsRiskConfiguration
    )
    def getAccountTakeoverRiskConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "accountTakeoverRiskConfiguration",
      accountTakeoverRiskConfiguration
    )
    def getRiskExceptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.RiskExceptionConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "riskExceptionConfiguration",
      riskExceptionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationRequest
  ) extends zio.aws.cognitoidentityprovider.model.SetRiskConfigurationRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val clientId: Option[ClientIdType] = scala
      .Option(impl.clientId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ClientIdType(value)
      )
    override val compromisedCredentialsRiskConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType.ReadOnly
    ] = scala
      .Option(impl.compromisedCredentialsRiskConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType
          .wrap(value)
      )
    override val accountTakeoverRiskConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType.ReadOnly
    ] = scala
      .Option(impl.accountTakeoverRiskConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType
          .wrap(value)
      )
    override val riskExceptionConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.RiskExceptionConfigurationType.ReadOnly
    ] = scala
      .Option(impl.riskExceptionConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.RiskExceptionConfigurationType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationRequest
  ): zio.aws.cognitoidentityprovider.model.SetRiskConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
