package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait AliasAttributeType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.AliasAttributeType
}
object AliasAttributeType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.AliasAttributeType
  ): zio.aws.cognitoidentityprovider.model.AliasAttributeType = value match {
    case software.amazon.awssdk.services.cognitoidentityprovider.model.AliasAttributeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.AliasAttributeType.PHONE_NUMBER =>
      val r = phone_number
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.AliasAttributeType.EMAIL =>
      val r = email
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.AliasAttributeType.PREFERRED_USERNAME =>
      val r = preferred_username
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.AliasAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AliasAttributeType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AliasAttributeType.UNKNOWN_TO_SDK_VERSION
  }
  case object phone_number
      extends zio.aws.cognitoidentityprovider.model.AliasAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AliasAttributeType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AliasAttributeType.PHONE_NUMBER
  }
  case object email
      extends zio.aws.cognitoidentityprovider.model.AliasAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AliasAttributeType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AliasAttributeType.EMAIL
  }
  case object preferred_username
      extends zio.aws.cognitoidentityprovider.model.AliasAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AliasAttributeType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AliasAttributeType.PREFERRED_USERNAME
  }
}
