package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RoleMapping(
    `type`: zio.aws.cognitoidentity.model.RoleMappingType,
    ambiguousRoleResolution: Optional[
      zio.aws.cognitoidentity.model.AmbiguousRoleResolutionType
    ] = Optional.Absent,
    rulesConfiguration: Optional[
      zio.aws.cognitoidentity.model.RulesConfigurationType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.RoleMapping = {
    import RoleMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.RoleMapping
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(ambiguousRoleResolution.map(value => value.unwrap))(
        _.ambiguousRoleResolution
      )
      .optionallyWith(rulesConfiguration.map(value => value.buildAwsValue()))(
        _.rulesConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentity.model.RoleMapping.ReadOnly =
    zio.aws.cognitoidentity.model.RoleMapping.wrap(buildAwsValue())
}
object RoleMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.RoleMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.RoleMapping =
      zio.aws.cognitoidentity.model.RoleMapping(
        `type`,
        ambiguousRoleResolution.map(value => value),
        rulesConfiguration.map(value => value.asEditable)
      )
    def `type`: zio.aws.cognitoidentity.model.RoleMappingType
    def ambiguousRoleResolution
        : Optional[zio.aws.cognitoidentity.model.AmbiguousRoleResolutionType]
    def rulesConfiguration: Optional[
      zio.aws.cognitoidentity.model.RulesConfigurationType.ReadOnly
    ]
    def getType
        : ZIO[Any, Nothing, zio.aws.cognitoidentity.model.RoleMappingType] =
      ZIO.succeed(`type`)
    def getAmbiguousRoleResolution: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentity.model.AmbiguousRoleResolutionType
    ] = AwsError.unwrapOptionField(
      "ambiguousRoleResolution",
      ambiguousRoleResolution
    )
    def getRulesConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentity.model.RulesConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField("rulesConfiguration", rulesConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.RoleMapping
  ) extends zio.aws.cognitoidentity.model.RoleMapping.ReadOnly {
    override val `type`: zio.aws.cognitoidentity.model.RoleMappingType =
      zio.aws.cognitoidentity.model.RoleMappingType.wrap(impl.`type`())
    override val ambiguousRoleResolution
        : Optional[zio.aws.cognitoidentity.model.AmbiguousRoleResolutionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ambiguousRoleResolution())
        .map(value =>
          zio.aws.cognitoidentity.model.AmbiguousRoleResolutionType.wrap(value)
        )
    override val rulesConfiguration: Optional[
      zio.aws.cognitoidentity.model.RulesConfigurationType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rulesConfiguration())
      .map(value =>
        zio.aws.cognitoidentity.model.RulesConfigurationType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.RoleMapping
  ): zio.aws.cognitoidentity.model.RoleMapping.ReadOnly = new Wrapper(impl)
}
