package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RulesConfigurationType(
    rules: Iterable[zio.aws.cognitoidentity.model.MappingRule]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.RulesConfigurationType = {
    import RulesConfigurationType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.RulesConfigurationType
      .builder()
      .rules(rules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.RulesConfigurationType.ReadOnly =
    zio.aws.cognitoidentity.model.RulesConfigurationType.wrap(buildAwsValue())
}
object RulesConfigurationType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.RulesConfigurationType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.RulesConfigurationType =
      zio.aws.cognitoidentity.model.RulesConfigurationType(rules.map { item =>
        item.asEditable
      })
    def rules: List[zio.aws.cognitoidentity.model.MappingRule.ReadOnly]
    def getRules: ZIO[Any, Nothing, List[
      zio.aws.cognitoidentity.model.MappingRule.ReadOnly
    ]] = ZIO.succeed(rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.RulesConfigurationType
  ) extends zio.aws.cognitoidentity.model.RulesConfigurationType.ReadOnly {
    override val rules
        : List[zio.aws.cognitoidentity.model.MappingRule.ReadOnly] = impl
      .rules()
      .asScala
      .map { item =>
        zio.aws.cognitoidentity.model.MappingRule.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.RulesConfigurationType
  ): zio.aws.cognitoidentity.model.RulesConfigurationType.ReadOnly =
    new Wrapper(impl)
}
