package zio.aws.cognitoidentity.model
import zio.aws.cognitoidentity.model.primitives.{
  QueryLimit,
  IdentityId,
  PaginationKey,
  DeveloperUserIdentifier,
  IdentityPoolId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class LookupDeveloperIdentityRequest(
    identityPoolId: IdentityPoolId,
    identityId: Optional[IdentityId] = Optional.Absent,
    developerUserIdentifier: Optional[DeveloperUserIdentifier] =
      Optional.Absent,
    maxResults: Optional[QueryLimit] = Optional.Absent,
    nextToken: Optional[PaginationKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityRequest = {
    import LookupDeveloperIdentityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityRequest
      .builder()
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .optionallyWith(
        identityId.map(value => IdentityId.unwrap(value): java.lang.String)
      )(_.identityId)
      .optionallyWith(
        developerUserIdentifier.map(value =>
          DeveloperUserIdentifier.unwrap(value): java.lang.String
        )
      )(_.developerUserIdentifier)
      .optionallyWith(
        maxResults.map(value => QueryLimit.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationKey.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.LookupDeveloperIdentityRequest.ReadOnly =
    zio.aws.cognitoidentity.model.LookupDeveloperIdentityRequest
      .wrap(buildAwsValue())
}
object LookupDeveloperIdentityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentity.model.LookupDeveloperIdentityRequest =
      zio.aws.cognitoidentity.model.LookupDeveloperIdentityRequest(
        identityPoolId,
        identityId.map(value => value),
        developerUserIdentifier.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def identityPoolId: IdentityPoolId
    def identityId: Optional[IdentityId]
    def developerUserIdentifier: Optional[DeveloperUserIdentifier]
    def maxResults: Optional[QueryLimit]
    def nextToken: Optional[PaginationKey]
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
    def getIdentityId: ZIO[Any, AwsError, IdentityId] =
      AwsError.unwrapOptionField("identityId", identityId)
    def getDeveloperUserIdentifier
        : ZIO[Any, AwsError, DeveloperUserIdentifier] = AwsError
      .unwrapOptionField("developerUserIdentifier", developerUserIdentifier)
    def getMaxResults: ZIO[Any, AwsError, QueryLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationKey] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityRequest
  ) extends zio.aws.cognitoidentity.model.LookupDeveloperIdentityRequest.ReadOnly {
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitoidentity.model.primitives
        .IdentityPoolId(impl.identityPoolId())
    override val identityId: Optional[IdentityId] = zio.aws.core.internal
      .optionalFromNullable(impl.identityId())
      .map(value => zio.aws.cognitoidentity.model.primitives.IdentityId(value))
    override val developerUserIdentifier: Optional[DeveloperUserIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.developerUserIdentifier())
        .map(value =>
          zio.aws.cognitoidentity.model.primitives
            .DeveloperUserIdentifier(value)
        )
    override val maxResults: Optional[QueryLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.cognitoidentity.model.primitives.QueryLimit(value))
    override val nextToken: Optional[PaginationKey] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentity.model.primitives.PaginationKey(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityRequest
  ): zio.aws.cognitoidentity.model.LookupDeveloperIdentityRequest.ReadOnly =
    new Wrapper(impl)
}
