package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentity.model.primitives.{
  ClassicFlow,
  DeveloperProviderName,
  ARNString,
  IdentityPoolUnauthenticated,
  IdentityProviderId,
  IdentityProviderName,
  TagKeysType,
  TagValueType,
  IdentityPoolName
}
import scala.jdk.CollectionConverters.*
final case class CreateIdentityPoolRequest(
    identityPoolName: IdentityPoolName,
    allowUnauthenticatedIdentities: IdentityPoolUnauthenticated,
    allowClassicFlow: Optional[ClassicFlow] = Optional.Absent,
    supportedLoginProviders: Optional[
      Map[IdentityProviderName, IdentityProviderId]
    ] = Optional.Absent,
    developerProviderName: Optional[DeveloperProviderName] = Optional.Absent,
    openIdConnectProviderARNs: Optional[Iterable[ARNString]] = Optional.Absent,
    cognitoIdentityProviders: Optional[
      Iterable[zio.aws.cognitoidentity.model.CognitoIdentityProvider]
    ] = Optional.Absent,
    samlProviderARNs: Optional[Iterable[ARNString]] = Optional.Absent,
    identityPoolTags: Optional[Map[TagKeysType, TagValueType]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.CreateIdentityPoolRequest = {
    import CreateIdentityPoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.CreateIdentityPoolRequest
      .builder()
      .identityPoolName(
        IdentityPoolName.unwrap(identityPoolName): java.lang.String
      )
      .allowUnauthenticatedIdentities(
        IdentityPoolUnauthenticated.unwrap(
          allowUnauthenticatedIdentities
        ): java.lang.Boolean
      )
      .optionallyWith(
        allowClassicFlow.map(value =>
          ClassicFlow.unwrap(value): java.lang.Boolean
        )
      )(_.allowClassicFlow)
      .optionallyWith(
        supportedLoginProviders.map(value =>
          value
            .map({ case (key, value) =>
              (IdentityProviderName.unwrap(
                key
              ): java.lang.String) -> (IdentityProviderId.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.supportedLoginProviders)
      .optionallyWith(
        developerProviderName.map(value =>
          DeveloperProviderName.unwrap(value): java.lang.String
        )
      )(_.developerProviderName)
      .optionallyWith(
        openIdConnectProviderARNs.map(value =>
          value.map { item =>
            ARNString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.openIdConnectProviderARNs)
      .optionallyWith(
        cognitoIdentityProviders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cognitoIdentityProviders)
      .optionallyWith(
        samlProviderARNs.map(value =>
          value.map { item =>
            ARNString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.samlProviderARNs)
      .optionallyWith(
        identityPoolTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKeysType.unwrap(key): java.lang.String) -> (TagValueType
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.identityPoolTags)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.CreateIdentityPoolRequest.ReadOnly =
    zio.aws.cognitoidentity.model.CreateIdentityPoolRequest
      .wrap(buildAwsValue())
}
object CreateIdentityPoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.CreateIdentityPoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.CreateIdentityPoolRequest =
      zio.aws.cognitoidentity.model.CreateIdentityPoolRequest(
        identityPoolName,
        allowUnauthenticatedIdentities,
        allowClassicFlow.map(value => value),
        supportedLoginProviders.map(value => value),
        developerProviderName.map(value => value),
        openIdConnectProviderARNs.map(value => value),
        cognitoIdentityProviders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        samlProviderARNs.map(value => value),
        identityPoolTags.map(value => value)
      )
    def identityPoolName: IdentityPoolName
    def allowUnauthenticatedIdentities: IdentityPoolUnauthenticated
    def allowClassicFlow: Optional[ClassicFlow]
    def supportedLoginProviders
        : Optional[Map[IdentityProviderName, IdentityProviderId]]
    def developerProviderName: Optional[DeveloperProviderName]
    def openIdConnectProviderARNs: Optional[List[ARNString]]
    def cognitoIdentityProviders: Optional[
      List[zio.aws.cognitoidentity.model.CognitoIdentityProvider.ReadOnly]
    ]
    def samlProviderARNs: Optional[List[ARNString]]
    def identityPoolTags: Optional[Map[TagKeysType, TagValueType]]
    def getIdentityPoolName: ZIO[Any, Nothing, IdentityPoolName] =
      ZIO.succeed(identityPoolName)
    def getAllowUnauthenticatedIdentities
        : ZIO[Any, Nothing, IdentityPoolUnauthenticated] =
      ZIO.succeed(allowUnauthenticatedIdentities)
    def getAllowClassicFlow: ZIO[Any, AwsError, ClassicFlow] =
      AwsError.unwrapOptionField("allowClassicFlow", allowClassicFlow)
    def getSupportedLoginProviders
        : ZIO[Any, AwsError, Map[IdentityProviderName, IdentityProviderId]] =
      AwsError.unwrapOptionField(
        "supportedLoginProviders",
        supportedLoginProviders
      )
    def getDeveloperProviderName: ZIO[Any, AwsError, DeveloperProviderName] =
      AwsError.unwrapOptionField("developerProviderName", developerProviderName)
    def getOpenIdConnectProviderARNs: ZIO[Any, AwsError, List[ARNString]] =
      AwsError.unwrapOptionField(
        "openIdConnectProviderARNs",
        openIdConnectProviderARNs
      )
    def getCognitoIdentityProviders: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentity.model.CognitoIdentityProvider.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cognitoIdentityProviders",
      cognitoIdentityProviders
    )
    def getSamlProviderARNs: ZIO[Any, AwsError, List[ARNString]] =
      AwsError.unwrapOptionField("samlProviderARNs", samlProviderARNs)
    def getIdentityPoolTags
        : ZIO[Any, AwsError, Map[TagKeysType, TagValueType]] =
      AwsError.unwrapOptionField("identityPoolTags", identityPoolTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.CreateIdentityPoolRequest
  ) extends zio.aws.cognitoidentity.model.CreateIdentityPoolRequest.ReadOnly {
    override val identityPoolName: IdentityPoolName =
      zio.aws.cognitoidentity.model.primitives
        .IdentityPoolName(impl.identityPoolName())
    override val allowUnauthenticatedIdentities: IdentityPoolUnauthenticated =
      zio.aws.cognitoidentity.model.primitives
        .IdentityPoolUnauthenticated(impl.allowUnauthenticatedIdentities())
    override val allowClassicFlow: Optional[ClassicFlow] = zio.aws.core.internal
      .optionalFromNullable(impl.allowClassicFlow())
      .map(value => zio.aws.cognitoidentity.model.primitives.ClassicFlow(value))
    override val supportedLoginProviders
        : Optional[Map[IdentityProviderName, IdentityProviderId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedLoginProviders())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.cognitoidentity.model.primitives.IdentityProviderName(
                key
              ) -> zio.aws.cognitoidentity.model.primitives
                .IdentityProviderId(value)
            })
            .toMap
        )
    override val developerProviderName: Optional[DeveloperProviderName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.developerProviderName())
        .map(value =>
          zio.aws.cognitoidentity.model.primitives.DeveloperProviderName(value)
        )
    override val openIdConnectProviderARNs: Optional[List[ARNString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.openIdConnectProviderARNs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cognitoidentity.model.primitives.ARNString(item)
          }.toList
        )
    override val cognitoIdentityProviders: Optional[
      List[zio.aws.cognitoidentity.model.CognitoIdentityProvider.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cognitoIdentityProviders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentity.model.CognitoIdentityProvider.wrap(item)
        }.toList
      )
    override val samlProviderARNs: Optional[List[ARNString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.samlProviderARNs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cognitoidentity.model.primitives.ARNString(item)
          }.toList
        )
    override val identityPoolTags: Optional[Map[TagKeysType, TagValueType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityPoolTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.cognitoidentity.model.primitives.TagKeysType(
                key
              ) -> zio.aws.cognitoidentity.model.primitives.TagValueType(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.CreateIdentityPoolRequest
  ): zio.aws.cognitoidentity.model.CreateIdentityPoolRequest.ReadOnly =
    new Wrapper(impl)
}
