package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentity.model.primitives.{
  IdentityPoolName,
  IdentityPoolId
}
import scala.jdk.CollectionConverters.*
final case class IdentityPoolShortDescription(
    identityPoolId: Optional[IdentityPoolId] = Optional.Absent,
    identityPoolName: Optional[IdentityPoolName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.IdentityPoolShortDescription = {
    import IdentityPoolShortDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.IdentityPoolShortDescription
      .builder()
      .optionallyWith(
        identityPoolId.map(value =>
          IdentityPoolId.unwrap(value): java.lang.String
        )
      )(_.identityPoolId)
      .optionallyWith(
        identityPoolName.map(value =>
          IdentityPoolName.unwrap(value): java.lang.String
        )
      )(_.identityPoolName)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.IdentityPoolShortDescription.ReadOnly =
    zio.aws.cognitoidentity.model.IdentityPoolShortDescription
      .wrap(buildAwsValue())
}
object IdentityPoolShortDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.IdentityPoolShortDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.IdentityPoolShortDescription =
      zio.aws.cognitoidentity.model.IdentityPoolShortDescription(
        identityPoolId.map(value => value),
        identityPoolName.map(value => value)
      )
    def identityPoolId: Optional[IdentityPoolId]
    def identityPoolName: Optional[IdentityPoolName]
    def getIdentityPoolId: ZIO[Any, AwsError, IdentityPoolId] =
      AwsError.unwrapOptionField("identityPoolId", identityPoolId)
    def getIdentityPoolName: ZIO[Any, AwsError, IdentityPoolName] =
      AwsError.unwrapOptionField("identityPoolName", identityPoolName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.IdentityPoolShortDescription
  ) extends zio.aws.cognitoidentity.model.IdentityPoolShortDescription.ReadOnly {
    override val identityPoolId: Optional[IdentityPoolId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityPoolId())
        .map(value =>
          zio.aws.cognitoidentity.model.primitives.IdentityPoolId(value)
        )
    override val identityPoolName: Optional[IdentityPoolName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityPoolName())
        .map(value =>
          zio.aws.cognitoidentity.model.primitives.IdentityPoolName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.IdentityPoolShortDescription
  ): zio.aws.cognitoidentity.model.IdentityPoolShortDescription.ReadOnly =
    new Wrapper(impl)
}
