package zio.aws.cognitoidentity.model
import zio.aws.cognitoidentity.model.primitives.{PaginationKey, QueryLimit}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListIdentityPoolsRequest(
    maxResults: QueryLimit,
    nextToken: Optional[PaginationKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsRequest = {
    import ListIdentityPoolsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsRequest
      .builder()
      .maxResults(QueryLimit.unwrap(maxResults): Integer)
      .optionallyWith(
        nextToken.map(value => PaginationKey.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.ListIdentityPoolsRequest.ReadOnly =
    zio.aws.cognitoidentity.model.ListIdentityPoolsRequest.wrap(buildAwsValue())
}
object ListIdentityPoolsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.ListIdentityPoolsRequest =
      zio.aws.cognitoidentity.model
        .ListIdentityPoolsRequest(maxResults, nextToken.map(value => value))
    def maxResults: QueryLimit
    def nextToken: Optional[PaginationKey]
    def getMaxResults: ZIO[Any, Nothing, QueryLimit] = ZIO.succeed(maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationKey] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsRequest
  ) extends zio.aws.cognitoidentity.model.ListIdentityPoolsRequest.ReadOnly {
    override val maxResults: QueryLimit =
      zio.aws.cognitoidentity.model.primitives.QueryLimit(impl.maxResults())
    override val nextToken: Optional[PaginationKey] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentity.model.primitives.PaginationKey(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsRequest
  ): zio.aws.cognitoidentity.model.ListIdentityPoolsRequest.ReadOnly =
    new Wrapper(impl)
}
