package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentity.model.primitives.{
  PaginationKey,
  DeveloperUserIdentifier,
  IdentityId
}
import scala.jdk.CollectionConverters.*
final case class LookupDeveloperIdentityResponse(
    identityId: Optional[IdentityId] = Optional.Absent,
    developerUserIdentifierList: Optional[Iterable[DeveloperUserIdentifier]] =
      Optional.Absent,
    nextToken: Optional[PaginationKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityResponse = {
    import LookupDeveloperIdentityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityResponse
      .builder()
      .optionallyWith(
        identityId.map(value => IdentityId.unwrap(value): java.lang.String)
      )(_.identityId)
      .optionallyWith(
        developerUserIdentifierList.map(value =>
          value.map { item =>
            DeveloperUserIdentifier.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.developerUserIdentifierList)
      .optionallyWith(
        nextToken.map(value => PaginationKey.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.LookupDeveloperIdentityResponse.ReadOnly =
    zio.aws.cognitoidentity.model.LookupDeveloperIdentityResponse
      .wrap(buildAwsValue())
}
object LookupDeveloperIdentityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentity.model.LookupDeveloperIdentityResponse =
      zio.aws.cognitoidentity.model.LookupDeveloperIdentityResponse(
        identityId.map(value => value),
        developerUserIdentifierList.map(value => value),
        nextToken.map(value => value)
      )
    def identityId: Optional[IdentityId]
    def developerUserIdentifierList: Optional[List[DeveloperUserIdentifier]]
    def nextToken: Optional[PaginationKey]
    def getIdentityId: ZIO[Any, AwsError, IdentityId] =
      AwsError.unwrapOptionField("identityId", identityId)
    def getDeveloperUserIdentifierList
        : ZIO[Any, AwsError, List[DeveloperUserIdentifier]] =
      AwsError.unwrapOptionField(
        "developerUserIdentifierList",
        developerUserIdentifierList
      )
    def getNextToken: ZIO[Any, AwsError, PaginationKey] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityResponse
  ) extends zio.aws.cognitoidentity.model.LookupDeveloperIdentityResponse.ReadOnly {
    override val identityId: Optional[IdentityId] = zio.aws.core.internal
      .optionalFromNullable(impl.identityId())
      .map(value => zio.aws.cognitoidentity.model.primitives.IdentityId(value))
    override val developerUserIdentifierList
        : Optional[List[DeveloperUserIdentifier]] = zio.aws.core.internal
      .optionalFromNullable(impl.developerUserIdentifierList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentity.model.primitives.DeveloperUserIdentifier(item)
        }.toList
      )
    override val nextToken: Optional[PaginationKey] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentity.model.primitives.PaginationKey(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityResponse
  ): zio.aws.cognitoidentity.model.LookupDeveloperIdentityResponse.ReadOnly =
    new Wrapper(impl)
}
