package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentity.model.primitives.ARNString
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceArn: ARNString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(ARNString.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.cognitoidentity.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.ListTagsForResourceRequest =
      zio.aws.cognitoidentity.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: ARNString
    def getResourceArn: ZIO[Any, Nothing, ARNString] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.ListTagsForResourceRequest
  ) extends zio.aws.cognitoidentity.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: ARNString =
      zio.aws.cognitoidentity.model.primitives.ARNString(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.ListTagsForResourceRequest
  ): zio.aws.cognitoidentity.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
