package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentity.model.primitives.IdentityId
import scala.jdk.CollectionConverters.*
final case class GetCredentialsForIdentityResponse(
    identityId: Optional[IdentityId] = Optional.Absent,
    credentials: Optional[zio.aws.cognitoidentity.model.Credentials] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.GetCredentialsForIdentityResponse = {
    import GetCredentialsForIdentityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.GetCredentialsForIdentityResponse
      .builder()
      .optionallyWith(
        identityId.map(value => IdentityId.unwrap(value): java.lang.String)
      )(_.identityId)
      .optionallyWith(credentials.map(value => value.buildAwsValue()))(
        _.credentials
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.GetCredentialsForIdentityResponse.ReadOnly =
    zio.aws.cognitoidentity.model.GetCredentialsForIdentityResponse
      .wrap(buildAwsValue())
}
object GetCredentialsForIdentityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.GetCredentialsForIdentityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentity.model.GetCredentialsForIdentityResponse =
      zio.aws.cognitoidentity.model.GetCredentialsForIdentityResponse(
        identityId.map(value => value),
        credentials.map(value => value.asEditable)
      )
    def identityId: Optional[IdentityId]
    def credentials
        : Optional[zio.aws.cognitoidentity.model.Credentials.ReadOnly]
    def getIdentityId: ZIO[Any, AwsError, IdentityId] =
      AwsError.unwrapOptionField("identityId", identityId)
    def getCredentials: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentity.model.Credentials.ReadOnly
    ] = AwsError.unwrapOptionField("credentials", credentials)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.GetCredentialsForIdentityResponse
  ) extends zio.aws.cognitoidentity.model.GetCredentialsForIdentityResponse.ReadOnly {
    override val identityId: Optional[IdentityId] = zio.aws.core.internal
      .optionalFromNullable(impl.identityId())
      .map(value => zio.aws.cognitoidentity.model.primitives.IdentityId(value))
    override val credentials
        : Optional[zio.aws.cognitoidentity.model.Credentials.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.credentials())
        .map(value => zio.aws.cognitoidentity.model.Credentials.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.GetCredentialsForIdentityResponse
  ): zio.aws.cognitoidentity.model.GetCredentialsForIdentityResponse.ReadOnly =
    new Wrapper(impl)
}
