package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentity.model.primitives.IdentityPoolId
import scala.jdk.CollectionConverters.*
final case class DescribeIdentityPoolRequest(identityPoolId: IdentityPoolId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityPoolRequest = {
    import DescribeIdentityPoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityPoolRequest
      .builder()
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.DescribeIdentityPoolRequest.ReadOnly =
    zio.aws.cognitoidentity.model.DescribeIdentityPoolRequest
      .wrap(buildAwsValue())
}
object DescribeIdentityPoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityPoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.DescribeIdentityPoolRequest =
      zio.aws.cognitoidentity.model.DescribeIdentityPoolRequest(identityPoolId)
    def identityPoolId: IdentityPoolId
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityPoolRequest
  ) extends zio.aws.cognitoidentity.model.DescribeIdentityPoolRequest.ReadOnly {
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitoidentity.model.primitives
        .IdentityPoolId(impl.identityPoolId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityPoolRequest
  ): zio.aws.cognitoidentity.model.DescribeIdentityPoolRequest.ReadOnly =
    new Wrapper(impl)
}
