package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentity.model.primitives.IdentityPoolId
import scala.jdk.CollectionConverters.*
final case class DeleteIdentityPoolRequest(identityPoolId: IdentityPoolId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentityPoolRequest = {
    import DeleteIdentityPoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentityPoolRequest
      .builder()
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.DeleteIdentityPoolRequest.ReadOnly =
    zio.aws.cognitoidentity.model.DeleteIdentityPoolRequest
      .wrap(buildAwsValue())
}
object DeleteIdentityPoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentityPoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.DeleteIdentityPoolRequest =
      zio.aws.cognitoidentity.model.DeleteIdentityPoolRequest(identityPoolId)
    def identityPoolId: IdentityPoolId
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentityPoolRequest
  ) extends zio.aws.cognitoidentity.model.DeleteIdentityPoolRequest.ReadOnly {
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitoidentity.model.primitives
        .IdentityPoolId(impl.identityPoolId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentityPoolRequest
  ): zio.aws.cognitoidentity.model.DeleteIdentityPoolRequest.ReadOnly =
    new Wrapper(impl)
}
