package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentity.model.primitives.{
  IdentityPoolId,
  DeveloperProviderName,
  DeveloperUserIdentifier
}
import scala.jdk.CollectionConverters.*
final case class MergeDeveloperIdentitiesRequest(
    sourceUserIdentifier: DeveloperUserIdentifier,
    destinationUserIdentifier: DeveloperUserIdentifier,
    developerProviderName: DeveloperProviderName,
    identityPoolId: IdentityPoolId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.MergeDeveloperIdentitiesRequest = {
    import MergeDeveloperIdentitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.MergeDeveloperIdentitiesRequest
      .builder()
      .sourceUserIdentifier(
        DeveloperUserIdentifier.unwrap(sourceUserIdentifier): java.lang.String
      )
      .destinationUserIdentifier(
        DeveloperUserIdentifier.unwrap(
          destinationUserIdentifier
        ): java.lang.String
      )
      .developerProviderName(
        DeveloperProviderName.unwrap(developerProviderName): java.lang.String
      )
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.MergeDeveloperIdentitiesRequest.ReadOnly =
    zio.aws.cognitoidentity.model.MergeDeveloperIdentitiesRequest
      .wrap(buildAwsValue())
}
object MergeDeveloperIdentitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.MergeDeveloperIdentitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentity.model.MergeDeveloperIdentitiesRequest =
      zio.aws.cognitoidentity.model.MergeDeveloperIdentitiesRequest(
        sourceUserIdentifier,
        destinationUserIdentifier,
        developerProviderName,
        identityPoolId
      )
    def sourceUserIdentifier: DeveloperUserIdentifier
    def destinationUserIdentifier: DeveloperUserIdentifier
    def developerProviderName: DeveloperProviderName
    def identityPoolId: IdentityPoolId
    def getSourceUserIdentifier: ZIO[Any, Nothing, DeveloperUserIdentifier] =
      ZIO.succeed(sourceUserIdentifier)
    def getDestinationUserIdentifier
        : ZIO[Any, Nothing, DeveloperUserIdentifier] =
      ZIO.succeed(destinationUserIdentifier)
    def getDeveloperProviderName: ZIO[Any, Nothing, DeveloperProviderName] =
      ZIO.succeed(developerProviderName)
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.MergeDeveloperIdentitiesRequest
  ) extends zio.aws.cognitoidentity.model.MergeDeveloperIdentitiesRequest.ReadOnly {
    override val sourceUserIdentifier: DeveloperUserIdentifier =
      zio.aws.cognitoidentity.model.primitives
        .DeveloperUserIdentifier(impl.sourceUserIdentifier())
    override val destinationUserIdentifier: DeveloperUserIdentifier =
      zio.aws.cognitoidentity.model.primitives
        .DeveloperUserIdentifier(impl.destinationUserIdentifier())
    override val developerProviderName: DeveloperProviderName =
      zio.aws.cognitoidentity.model.primitives
        .DeveloperProviderName(impl.developerProviderName())
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitoidentity.model.primitives
        .IdentityPoolId(impl.identityPoolId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.MergeDeveloperIdentitiesRequest
  ): zio.aws.cognitoidentity.model.MergeDeveloperIdentitiesRequest.ReadOnly =
    new Wrapper(impl)
}
