package zio.aws.cognitoidentity.model
import scala.jdk.CollectionConverters.*
sealed trait AmbiguousRoleResolutionType {
  def unwrap: software.amazon.awssdk.services.cognitoidentity.model.AmbiguousRoleResolutionType
}
object AmbiguousRoleResolutionType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentity.model.AmbiguousRoleResolutionType
  ): zio.aws.cognitoidentity.model.AmbiguousRoleResolutionType = value match {
    case software.amazon.awssdk.services.cognitoidentity.model.AmbiguousRoleResolutionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentity.model.AmbiguousRoleResolutionType.AUTHENTICATED_ROLE =>
      val r = AuthenticatedRole
      r
    case software.amazon.awssdk.services.cognitoidentity.model.AmbiguousRoleResolutionType.DENY =>
      val r = Deny
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentity.model.AmbiguousRoleResolutionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentity.model.AmbiguousRoleResolutionType =
      software.amazon.awssdk.services.cognitoidentity.model.AmbiguousRoleResolutionType.UNKNOWN_TO_SDK_VERSION
  }
  case object AuthenticatedRole
      extends zio.aws.cognitoidentity.model.AmbiguousRoleResolutionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentity.model.AmbiguousRoleResolutionType =
      software.amazon.awssdk.services.cognitoidentity.model.AmbiguousRoleResolutionType.AUTHENTICATED_ROLE
  }
  case object Deny
      extends zio.aws.cognitoidentity.model.AmbiguousRoleResolutionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentity.model.AmbiguousRoleResolutionType =
      software.amazon.awssdk.services.cognitoidentity.model.AmbiguousRoleResolutionType.DENY
  }
}
