package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentity.model.primitives.{
  IdentityProviderToken,
  IdentityProviderName,
  IdentityId
}
import scala.jdk.CollectionConverters.*
final case class GetOpenIdTokenRequest(
    identityId: IdentityId,
    logins: Optional[Map[IdentityProviderName, IdentityProviderToken]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenRequest = {
    import GetOpenIdTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenRequest
      .builder()
      .identityId(IdentityId.unwrap(identityId): java.lang.String)
      .optionallyWith(
        logins.map(value =>
          value
            .map({ case (key, value) =>
              (IdentityProviderName
                .unwrap(key): java.lang.String) -> (IdentityProviderToken
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.logins)
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentity.model.GetOpenIdTokenRequest.ReadOnly =
    zio.aws.cognitoidentity.model.GetOpenIdTokenRequest.wrap(buildAwsValue())
}
object GetOpenIdTokenRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.GetOpenIdTokenRequest =
      zio.aws.cognitoidentity.model
        .GetOpenIdTokenRequest(identityId, logins.map(value => value))
    def identityId: IdentityId
    def logins: Optional[Map[IdentityProviderName, IdentityProviderToken]]
    def getIdentityId: ZIO[Any, Nothing, IdentityId] = ZIO.succeed(identityId)
    def getLogins
        : ZIO[Any, AwsError, Map[IdentityProviderName, IdentityProviderToken]] =
      AwsError.unwrapOptionField("logins", logins)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenRequest
  ) extends zio.aws.cognitoidentity.model.GetOpenIdTokenRequest.ReadOnly {
    override val identityId: IdentityId =
      zio.aws.cognitoidentity.model.primitives.IdentityId(impl.identityId())
    override val logins
        : Optional[Map[IdentityProviderName, IdentityProviderToken]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logins())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.cognitoidentity.model.primitives.IdentityProviderName(
                key
              ) -> zio.aws.cognitoidentity.model.primitives
                .IdentityProviderToken(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenRequest
  ): zio.aws.cognitoidentity.model.GetOpenIdTokenRequest.ReadOnly = new Wrapper(
    impl
  )
}
