package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentity.model.primitives.{
  PrincipalTagID,
  PrincipalTagValue,
  UseDefaults,
  IdentityPoolId,
  IdentityProviderName
}
import scala.jdk.CollectionConverters.*
final case class SetPrincipalTagAttributeMapResponse(
    identityPoolId: Optional[IdentityPoolId] = Optional.Absent,
    identityProviderName: Optional[IdentityProviderName] = Optional.Absent,
    useDefaults: Optional[UseDefaults] = Optional.Absent,
    principalTags: Optional[Map[PrincipalTagID, PrincipalTagValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.SetPrincipalTagAttributeMapResponse = {
    import SetPrincipalTagAttributeMapResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.SetPrincipalTagAttributeMapResponse
      .builder()
      .optionallyWith(
        identityPoolId.map(value =>
          IdentityPoolId.unwrap(value): java.lang.String
        )
      )(_.identityPoolId)
      .optionallyWith(
        identityProviderName.map(value =>
          IdentityProviderName.unwrap(value): java.lang.String
        )
      )(_.identityProviderName)
      .optionallyWith(
        useDefaults.map(value => UseDefaults.unwrap(value): java.lang.Boolean)
      )(_.useDefaults)
      .optionallyWith(
        principalTags.map(value =>
          value
            .map({ case (key, value) =>
              (PrincipalTagID
                .unwrap(key): java.lang.String) -> (PrincipalTagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.principalTags)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.SetPrincipalTagAttributeMapResponse.ReadOnly =
    zio.aws.cognitoidentity.model.SetPrincipalTagAttributeMapResponse
      .wrap(buildAwsValue())
}
object SetPrincipalTagAttributeMapResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.SetPrincipalTagAttributeMapResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentity.model.SetPrincipalTagAttributeMapResponse =
      zio.aws.cognitoidentity.model.SetPrincipalTagAttributeMapResponse(
        identityPoolId.map(value => value),
        identityProviderName.map(value => value),
        useDefaults.map(value => value),
        principalTags.map(value => value)
      )
    def identityPoolId: Optional[IdentityPoolId]
    def identityProviderName: Optional[IdentityProviderName]
    def useDefaults: Optional[UseDefaults]
    def principalTags: Optional[Map[PrincipalTagID, PrincipalTagValue]]
    def getIdentityPoolId: ZIO[Any, AwsError, IdentityPoolId] =
      AwsError.unwrapOptionField("identityPoolId", identityPoolId)
    def getIdentityProviderName: ZIO[Any, AwsError, IdentityProviderName] =
      AwsError.unwrapOptionField("identityProviderName", identityProviderName)
    def getUseDefaults: ZIO[Any, AwsError, UseDefaults] =
      AwsError.unwrapOptionField("useDefaults", useDefaults)
    def getPrincipalTags
        : ZIO[Any, AwsError, Map[PrincipalTagID, PrincipalTagValue]] =
      AwsError.unwrapOptionField("principalTags", principalTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.SetPrincipalTagAttributeMapResponse
  ) extends zio.aws.cognitoidentity.model.SetPrincipalTagAttributeMapResponse.ReadOnly {
    override val identityPoolId: Optional[IdentityPoolId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityPoolId())
        .map(value =>
          zio.aws.cognitoidentity.model.primitives.IdentityPoolId(value)
        )
    override val identityProviderName: Optional[IdentityProviderName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityProviderName())
        .map(value =>
          zio.aws.cognitoidentity.model.primitives.IdentityProviderName(value)
        )
    override val useDefaults: Optional[UseDefaults] = zio.aws.core.internal
      .optionalFromNullable(impl.useDefaults())
      .map(value => zio.aws.cognitoidentity.model.primitives.UseDefaults(value))
    override val principalTags
        : Optional[Map[PrincipalTagID, PrincipalTagValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.principalTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.cognitoidentity.model.primitives
                .PrincipalTagID(key) -> zio.aws.cognitoidentity.model.primitives
                .PrincipalTagValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.SetPrincipalTagAttributeMapResponse
  ): zio.aws.cognitoidentity.model.SetPrincipalTagAttributeMapResponse.ReadOnly =
    new Wrapper(impl)
}
